/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.util.Set;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.GenericDateValue;
import be.WAAR.PresentationLayer.GenericIntegerValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ISODateFormat;
import be.WAAR.PresentationLayer.LogicalValue;

/**
 * @author Erwin
 * 
 */
public abstract class BWSpotsFunction extends BWWebClientFunction {

	/**
	 * @return
	 * @throws Problem
	 */
	AbstractRelation getMatchingSpots ( ) throws Problem {

		GenericStringValue name = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME);
		String unknownGenderSpotsQuery = "EXTEND(" + BWDBRELVARNAMES.SPOTS + ",(GENDERKNOWN(BOOLEAN(FALSE))" + BWDBATTRIBUTENAMES.GENDER + "(STRING( ))))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String knownGenderSpotsQuery = "TRANSFORM(RENAME(" + BWDBRELVARNAMES.GSPOTS + ",(" + BWDBATTRIBUTENAMES.GENDER + ",G)),(" + BWDBATTRIBUTENAMES.SPOTCOUNT + "," + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + ",GENDERKNOWN(BOOLEAN(TRUE))," + BWDBATTRIBUTENAMES.GENDER + "(THE_STRING(G))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
		String spotsQuery;
		if (((LogicalValue) getPresentationValue("SELECTBYKNOWNORUNKNOWNGENDER")).getValue()) { //$NON-NLS-1$
			if (((LogicalValue) getPresentationValue("GENDERKNOWN")).getValue()) { //$NON-NLS-1$
				GenericStringValue wv_gender = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.GENDER);
				if (wv_gender.getString().equalsIgnoreCase(" ")) { //$NON-NLS-1$
					spotsQuery = knownGenderSpotsQuery;
				} else {
					spotsQuery = "RESTRICT(" + knownGenderSpotsQuery + ",EQ(GENDER,STRING(" + wv_gender.getString() + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
				}
			} else {
				spotsQuery = unknownGenderSpotsQuery;
			}
		} else {
			spotsQuery = "UNION(" + unknownGenderSpotsQuery + "," + knownGenderSpotsQuery + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ 
		}
		if (name != null) {
			Set<String> names = RelationValueSelectorFactory.getNames(name.getString());
			String nameValueSelector = RelationValueSelectorFactory.getRelationValueSelector(names, BWDBATTRIBUTENAMES.SPECIESNAME, TYPENAMES.STRING);
			spotsQuery = "JOIN(" + spotsQuery + "," + nameValueSelector + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}

		GenericDateValue walkDate = (GenericDateValue) getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE);
		if (walkDate != null) {
			spotsQuery = "RESTRICT(" + spotsQuery + ",EQ(DATE(" + ISODateFormat.formatISO(walkDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		} else {
			GenericDateValue fromDate = (GenericDateValue) getPresentationValue("FROMDATE"); //$NON-NLS-1$
			if (fromDate != null) {
				spotsQuery = "RESTRICT(" + spotsQuery + ",NOT(GT(DATE(" + ISODateFormat.formatISO(fromDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}

			GenericDateValue toDate = (GenericDateValue) getPresentationValue("TODATE"); //$NON-NLS-1$
			if (toDate != null) {
				spotsQuery = "RESTRICT(" + spotsQuery + ",GT(DATE(" + ISODateFormat.formatISO(toDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}
		}

		GenericIntegerValue fromCount = (GenericIntegerValue) getPresentationValue("FROMCOUNT"); //$NON-NLS-1$
		if (fromCount != null) {
			spotsQuery = "RESTRICT(" + spotsQuery + ",NOT(GT(INT(" + fromCount + ")," + BWDBATTRIBUTENAMES.SPOTCOUNT + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		}

		GenericIntegerValue toCount = (GenericIntegerValue) getPresentationValue("TOCOUNT"); //$NON-NLS-1$
		if (toCount != null) {
			spotsQuery = "RESTRICT(" + spotsQuery + ",GT(INT(" + toCount + ")," + BWDBATTRIBUTENAMES.SPOTCOUNT + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		}

		GenericStringValue language = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
		if (language != null) {
			spotsQuery = "EXTEND(LEFTJOIN(" + spotsQuery + ",PROJECT(RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",EQ(" + BWDBATTRIBUTENAMES.LANGUAGE + ",LANGUAGE(ISO2(" + language.getString() + ")))),(" + BWDBATTRIBUTENAMES.SPECIESNAME + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + ")),(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + "(STRING( )))),(NLANNOTATEDNAME(CONCAT(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",CONCAT(STRING( -),CONCAT(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + ",STRING(-)))))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
		}

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			return dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.READONLY).execQueryAndEndTransaction(spotsQuery); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
