/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.util.Set;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.WAAR.PresentationLayer.GenericDateValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.ISODateFormat;

/**
 * @author Erwin
 * 
 */
public abstract class BWWalksFunction extends BWWebClientFunction {

	/**
	 * @return
	 * @throws Problem
	 */
	final AbstractRelation getMatchingSpots ( ) throws Problem {

		String spotsQuery = "UNION(EXTEND(" + BWDBRELVARNAMES.SPOTS + ",(G(STRING( )))),TRANSFORM(" + BWDBRELVARNAMES.GSPOTS + ",(" + BWDBATTRIBUTENAMES.SPOTCOUNT + "," + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + ",G(THE_STRING(" + BWDBATTRIBUTENAMES.GENDER + ")))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

		GenericDateValue walkDate = (GenericDateValue) getPresentationValue("WALKDATE"); //$NON-NLS-1$
		spotsQuery = "RESTRICT(" + spotsQuery + ",EQ(DATE(" + ISODateFormat.formatISO(walkDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$

		GenericStringValue language = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
		if (language != null) {
			spotsQuery = "EXTEND(LEFTJOIN(" + spotsQuery + ",PROJECT(RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",EQ(" + BWDBATTRIBUTENAMES.LANGUAGE + ",LANGUAGE(ISO2(" + language.getString() + ")))),(" + BWDBATTRIBUTENAMES.SPECIESNAME + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + ")),(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + "(STRING( )))),(NLANNOTATEDNAME(CONCAT(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",CONCAT(STRING( -),CONCAT(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + ",STRING(-)))))))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
		}

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			return dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.READONLY).execQueryAndEndTransaction(spotsQuery); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}

	}

	/**
	 * @return
	 * @throws Problem
	 */
	final AbstractRelation getMatchingWalks ( ) throws Problem {

		String walkDatesQuery = BWDBRELVARNAMES.WALK;

		GenericStringValue name = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME);
		if (name != null) {
			Set<String> names = RelationValueSelectorFactory.getNames(name.getString());
			String nameValueSelector = RelationValueSelectorFactory.getRelationValueSelector(names, BWDBATTRIBUTENAMES.SPECIESNAME, TYPENAMES.STRING);
			walkDatesQuery = "PROJECT(JOIN(UNION(" + BWDBRELVARNAMES.SPOTS + ",PROJECT(" + BWDBRELVARNAMES.GSPOTS + ",(" + BWDBATTRIBUTENAMES.SPOTCOUNT + "," + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + ")))," + nameValueSelector + "),(" + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
		}

		GenericDateValue walkDate = (GenericDateValue) getPresentationValue("WALKDATE"); //$NON-NLS-1$
		if (walkDate != null) {
			walkDatesQuery = "RESTRICT(" + walkDatesQuery + ",EQ(DATE(" + ISODateFormat.formatISO(walkDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		} else {
			GenericDateValue fromDate = (GenericDateValue) getPresentationValue("FROMDATE"); //$NON-NLS-1$
			if (fromDate != null) {
				walkDatesQuery = "RESTRICT(" + walkDatesQuery + ",NOT(GT(DATE(" + ISODateFormat.formatISO(fromDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + ")))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}

			GenericDateValue toDate = (GenericDateValue) getPresentationValue("TODATE"); //$NON-NLS-1$
			if (toDate != null) {
				walkDatesQuery = "RESTRICT(" + walkDatesQuery + ",GT(DATE(" + ISODateFormat.formatISO(toDate.getDate()) + ")," + BWDBATTRIBUTENAMES.WALKDATE + "))"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			}
		}

		GenericStringValue language = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
		if (language != null) {
			walkDatesQuery = "LEFTJOIN(" + walkDatesQuery + ",GROUP(TRANSFORM(LEFTJOIN(UNION(PROJECT(" + BWDBRELVARNAMES.SPOTS + ",(" + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + ")),PROJECT(" + BWDBRELVARNAMES.GSPOTS + ",(" + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + "))),PROJECT(RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",EQ(" + BWDBATTRIBUTENAMES.LANGUAGE + ",LANGUAGE(ISO2(" + ((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE)).getString() + ")))),(" + BWDBATTRIBUTENAMES.SPECIESNAME + "," + BWDBATTRIBUTENAMES.NLSPECIESNAME + "))," + BWDBATTRIBUTENAMES.NLSPECIESNAME + "(STRING( ))),(" + BWDBATTRIBUTENAMES.WALKDATE + "," + BWDBATTRIBUTENAMES.SPECIESNAME + ",NLANNOTATEDNAME(CONCAT(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",CONCAT(STRING( -),CONCAT(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + ",STRING(-))))))),SPOTTEDSPECIESLIST(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",NLANNOTATEDNAME)),(SPOTTEDSPECIESLIST(RELATION(HEADING(" + BWDBATTRIBUTENAMES.SPECIESNAME + "(STRING)NLANNOTATEDNAME(STRING))BODY())))),(" + BWDBATTRIBUTENAMES.WALKDATE + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$ //$NON-NLS-15$ //$NON-NLS-16$ //$NON-NLS-17$ //$NON-NLS-18$ //$NON-NLS-19$ //$NON-NLS-20$ //$NON-NLS-21$
		}

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			return dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.READONLY).execQueryAndEndTransaction(walkDatesQuery); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}
}
