/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.CommunicationProtocolException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBException;
import be.SIRAPRISE.client.OneShotDBConnection;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.WaarListFactory;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.List;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;

/**
 * @author Erwin
 * 
 */
public abstract class BWWebClientFunction extends OnLinePresentationFunction {

	/**
	 * 
	 */
	static final String CLIENTNAME = "BIRDWATCHER"; //$NON-NLS-1$

	/**
	 * 
	 */
	static BWWebClientProperties bwWebClientProperties = BWWebClientProperties.getInstance();

	/**
	 * @param locale
	 * @return
	 * @throws Problem
	 */
	DBConnection getDBConnection (Locale locale) throws Problem {
		try {
			return new OneShotDBConnection(bwWebClientProperties.getServer(), bwWebClientProperties.getPort(), bwWebClientProperties.getClientSigningAlgorithmNames(), CLIENTNAME, bwWebClientProperties.getCryptoAlgorithmNames(), BirdwatcherSigner.getInstance());
		} catch (IOException e) {
			log(e);
			throw new Problem(e, locale);
		} catch (CommunicationProtocolException e) {
			log(e);
			throw new Problem(e, locale);
		} catch (DBException e) {
			log(e);
			throw new Problem(e, locale);
		}
	}

	/**
	 * @param listFieldName
	 *            The name of the list field on the presentation to be filled from the given relation
	 * @param r
	 *            The relation holding the tuples to create the list table rows from
	 * @param escapeProcessingForColumnNames
	 *            The set of column names for which SIRA_PRISE escape character removal is to be applied
	 * @return A ListValue holding the information contained in the relationValue argument
	 * @throws WaarException
	 */
	final ListValue getWAARListValue (String listFieldName, AbstractRelation r, Set<String> escapeProcessingForColumnNames) throws WaarException {
		Locale locale = getUserLocale();
		PresentationField listField = getPresentation().getPresentationField(listFieldName, locale);
		ListValue listValue = new ListValue(listFieldName);

		Iterator<Tuple> i_tuples = r.iterator();
		while (i_tuples.hasNext()) {
			HashMap<String, WaarValue> m = new HashMap<String, WaarValue>();
			AbstractTuple tuple = (AbstractTuple) i_tuples.next();
			IntersectableMap<?, ?> tupleAttributeValues = tuple.values();
			Iterator<?> i_tupleAttributeValues = tupleAttributeValues.entrySet().iterator();
			while (i_tupleAttributeValues.hasNext()) {
				Map.Entry<?, ?> me = (Entry<?, ?>) i_tupleAttributeValues.next();
				String attributeName = (String) me.getKey();
				String attributeValue = (String) me.getValue();
				// BracketParseResult attributeValueParseResult = BracketParser.getContentsWithinBrackets(attributeValue);
				PresentationField listColumnField = listField.getColumn(attributeName, locale);
				if (listColumnField != null) {
					WaarValue listAttributeValue;
					if (listColumnField.getType() instanceof List) {
						listAttributeValue = WaarListFactory.fromSiraPriseRelationValue(listColumnField, attributeValue, getUserData(), locale);
					} else {
						if (escapeProcessingForColumnNames != null && escapeProcessingForColumnNames.contains(attributeName)) {
							try {
								attributeValue = BracketParser.unMeta(attributeValue);
							} catch (InvalidEscapedCharacterException e) {
								throw new RuntimeException(e);
							} catch (MissingEscapedCharacterException e) {
								throw new RuntimeException(e);
							}
						}
						listAttributeValue = listColumnField.getType().encode(attributeValue, getUserData(), locale);
					}
					m.put(attributeName, listAttributeValue);
				}
			}
			listValue.append(m);
		}
		return listValue;
	}

	/**
	 * 
	 */
	protected final void setDefaultLanguageFromUserContext ( ) {
		try {
			setPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE, new GenericStringValue(getUserLocale().getLanguage()));
		} catch (WaarException e) {
			Logger.getLogger(this.getClass().getName()).log(Level.INFO, "", e); //$NON-NLS-1$
		}
	}

}
