/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.util.Set;

import be.SIRAPRISE.client.DBConnectionProperties;
import be.erwinsmout.MyProperties;

/**
 * @author Erwin
 * 
 */
final class BWWebClientProperties extends MyProperties {

	/**
	 * 
	 */
	private static BWWebClientProperties instance = new BWWebClientProperties();

	/**
	 * 
	 */
	private static final long serialVersionUID = 7671132371205991314L;

	/**
	 * @return
	 */
	static BWWebClientProperties getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private Set<String> clientSigningAlgorithmNames;

	/**
	 * 
	 */
	private Set<String> cryptoAlgorithmNames;

	/**
	 * 
	 */
	private int port;

	/**
	 * 
	 */
	private String server;

	/**
	 * Creates the BWWebClientProperties
	 * 
	 */
	private BWWebClientProperties ( ) {
		super(DBConnectionProperties.getInstance());
		
		server = getProperty(DBConnectionProperties.HOST, DBConnectionProperties.HOSTDEFAULT);
		port = Integer.parseInt(getProperty(DBConnectionProperties.PORT, DBConnectionProperties.PORTDEFAULT));
		clientSigningAlgorithmNames = DBConnectionProperties.getSigningAlgorithmNameSet(getProperty(DBConnectionProperties.SIGNINGALGORITHMS, DBConnectionProperties.DEFAULTSIGNATUREALGORITHMNAMESDEFAULT));
		cryptoAlgorithmNames = DBConnectionProperties.getCryptoAlgorithmNameSet(getProperty(DBConnectionProperties.CRYPTOALGORITHMS, DBConnectionProperties.DEFAULTENCRYPTIONALGORITHMNAMESDEFAULT));
	}

	/**
	 * @return
	 */
	Set<String> getClientSigningAlgorithmNames ( ) {
		return clientSigningAlgorithmNames;
	}

	/**
	 * @return
	 */
	Set<String> getCryptoAlgorithmNames ( ) {
		return cryptoAlgorithmNames;
	}

	/**
	 * @return
	 */
	int getPort ( ) {
		return port;
	}

	/**
	 * @return
	 */
	String getServer ( ) {
		return server;
	}
}
