/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Locale;

import be.SIRAPRISE.client.NAMES;
import be.SIRAPRISE.client.Signer;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;

/**
 * @author Erwin
 * 
 */
final class BirdwatcherSigner implements Signer {

	/**
	 * 
	 */
	private static final String BIRDWATCHER_KEYSTORE = "birdwatcher.keystore"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static Signer instance = new BirdwatcherSigner();

	/**
	 * @return
	 */
	static Signer getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private HashMap<String, PrivateKey> privateKeysPerAlgorithm = new HashMap<String, PrivateKey>();

	/**
	 * Creates the BirdwatcherSigner
	 * 
	 */
	private BirdwatcherSigner ( ) {

	}

	/**
	 * @param algorithmName
	 * @return
	 * @throws NotFoundException
	 */
	private PrivateKey getPrivateKey (String algorithmName) throws NotFoundException {
		PrivateKey privateKey = privateKeysPerAlgorithm.get(algorithmName);
		if (privateKey == null) {
			try {
				// Get the keystore
				KeyStore jks = KeyStore.getInstance(NAMES.DEFAULTKEYSTORETYPE);
				InputStream keystoreInputStream = this.getClass().getResourceAsStream("/" + BIRDWATCHER_KEYSTORE); //$NON-NLS-1$
				if (keystoreInputStream != null) {
					final char[] birdWatcherCharArray = new String("birdwatcher").toCharArray(); //$NON-NLS-1$
					jks.load(keystoreInputStream, birdWatcherCharArray);

					// Get the private Key from the keystore. This is the key that is stored in the webclient's configured keystore for the alias that is equal to the clientID, suffixed with the algorithm name
					privateKey = (PrivateKey) jks.getKey(BWWebClientFunction.CLIENTNAME + algorithmName, birdWatcherCharArray);
					privateKeysPerAlgorithm.put(algorithmName, privateKey);
				} else {
					throw new NotFoundException(MyMessageFormat.format(I18N.getString(Locale.getDefault(), "BirdwatcherSigner.0"), new String[] { BIRDWATCHER_KEYSTORE })); //$NON-NLS-1$
				}
			} catch (KeyStoreException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (NoSuchAlgorithmException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (CertificateException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (IOException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			} catch (UnrecoverableKeyException e) {
				throw new NotFoundException(e.getClass().getName() + (e.getMessage() != null ? ('-' + e.getMessage()) : "")); //$NON-NLS-1$
			}
		}

		return privateKey;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.Signer#sign(java.security.Signature, byte[])
	 */
	@Override
	public byte[] sign (Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
		signature.initSign(getPrivateKey(signature.getAlgorithm()));
		signature.update(signMessage);
		return signature.sign();
	}

}
