/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;

/**
 * @author Erwin
 * 
 */
public final class ExistingSpecies extends AbstractUpdatableDBObject implements DBObjectToExistingspecies, ExistingspeciesToDBObject, DBObjectToPossiblespecies, PossiblespeciesToDBObject {

	/**
	 * The scientific name
	 */
	private String name;

	/**
	 * 
	 */
	private ExistingSpecies preUpdateState;

	/**
	 * Creates the ExistingSpecies
	 */
	public ExistingSpecies ( ) {
		this(""); //$NON-NLS-1$
	}

	/**
	 * Creates the ExistingSpecies
	 * 
	 * @param name
	 *            The scientific name
	 */
	public ExistingSpecies (String name) {
		this.name = name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.DBObjectToExistingspecies#getExistingspeciesSpeciesname()
	 */
	@Override
	public String getExistingspeciesSpeciesname ( ) {
		return BracketParser.meta(name);
	}

	/**
	 * Gets The scientific name
	 * 
	 * @return The scientific name
	 */
	public final String getName ( ) {
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Sets The scientific name
	 * 
	 * @param name
	 *            The scientific name
	 */
	public final void setName (String name) {
		this.name = name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		preUpdateState = new ExistingSpecies(name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.ExistingspeciesToDBObject#setSpeciesnameFromDB(java.lang.String)
	 */
	@Override
	public void setSpeciesnameFromDB (String speciesname) {
		name = BracketParser.unMetaWithoutException(speciesname);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToPossiblespecies#getPossiblespeciesSpeciesname()
	 */
	@Override
	public String getPossiblespeciesSpeciesname ( ) {
		return getExistingspeciesSpeciesname();
	}
}
