package be.SIRAPRISE.birdwatcher;

import java.util.LinkedList;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.WAAR.PresentationLayer.*;

/**
 * The function to create a new existing species
 * 
 * @author Erwin
 */
public class ExistingSpeciesCreate extends BWSpeciesFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		String speciesName = ((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME)).getString();
		GenericStringValue language_wv = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
		GenericStringValue nlSpeciesName_wv = (GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME);

		LinkedList<DmlAssignmentCommand> commands = new LinkedList<DmlAssignmentCommand>();
		ExistingSpecies existingSpecies = new ExistingSpecies(speciesName);
		commands.add(existingSpecies.dbAddCommand(BWDBRELVARNAMES.EXISTINGSPECIES));

		if (((LogicalValue) getPresentationValue("MARKASPOSSIBLE")).getValue()) { //$NON-NLS-1$
			commands.add(existingSpecies.dbAddCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
		}
		
		if (language_wv != null) {
			if (nlSpeciesName_wv != null) {
				commands.addLast(new NLSpeciesName(speciesName, language_wv.getString(), nlSpeciesName_wv.getString()).dbAddCommand(BWDBRELVARNAMES.NLSPECIESNAME));
			} else {
				throw new PleaseSpecifyBothLanguageAndNameException(getUserLocale());
			}
		} else {
			if (nlSpeciesName_wv != null) {
				throw new PleaseSpecifyBothLanguageAndNameException(getUserLocale());
			}
		}

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ExistingSpeciesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}