package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.*;

/**
 * The function to delete a new existing species
 * 
 * @author Erwin
 */
public class ExistingSpeciesDelete extends BWSpeciesFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * 
	 */
	@SuppressWarnings("unchecked")
	private void processDeleteConfirmation ( ) throws WaarException {

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			LinkedList<DmlAssignmentCommand> commands = (LinkedList<DmlAssignmentCommand>) getFromFunctionContextMandatory("commands"); //$NON-NLS-1$
			if (((LogicalValue) getPresentationValue("UNMARKASPOSSIBLE")).getValue()) { //$NON-NLS-1$
				commands.addLast((DmlAssignmentCommand) getFromFunctionContextMandatory("UNMARKASPOSSIBLE")); //$NON-NLS-1$
			}
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}

	}

	/**
	 * @throws WaarException
	 * 
	 */
	private void processSelectionPresentation ( ) throws WaarException {

		AbstractRelation r = getMatchingSpecies();

		if (r.size() == 1) {
			ExistingSpecies species;
			try {
				species = r.toObjectCollectionIgnoringMissingSetters(ExistingSpecies.class).iterator().next();
			} catch (ConstructorMissingException e) {
				throw new WAARApplicationException(e, getUserLocale());
			} catch (ClassDoesNotImplementDBObjectException e) {
				throw new WAARApplicationException(e, getUserLocale());
			}
			setPresentation("ExistingSpeciesDeleteConfirm"); //$NON-NLS-1$
			setPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME, species.getName());

			AbstractRelation nlNames = r.iterator().next().rvaValue("NLSPECIESNAMELIST"); //$NON-NLS-1$
			setPresentationValue("NLSPECIESNAMELIST", getWAARListValue("NLSPECIESNAMELIST", nlNames, new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$

			LinkedList<DmlAssignmentCommand> commands = new LinkedList<DmlAssignmentCommand>();
			commands.add(species.dbDeleteCommand(BWDBRELVARNAMES.EXISTINGSPECIES));
			for (Tuple nlNameTuple : nlNames) {
				commands.add(new NLSpeciesName(species.getName(), nlNameTuple.value(BWDBATTRIBUTENAMES.LANGUAGE), nlNameTuple.value(BWDBATTRIBUTENAMES.NLSPECIESNAME)).dbDeleteCommand(BWDBRELVARNAMES.NLSPECIESNAME));
			}

			saveInFunctionContext("commands", commands); //$NON-NLS-1$
			saveInFunctionContext("UNMARKASPOSSIBLE", species.dbUnAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES)); //$NON-NLS-1$
		} else {
			setPresentationValue("SPECIESLIST", getWAARListValue("SPECIESLIST", getMatchingSpecies(), new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setDefaultLanguageFromUserContext();
		if (getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null || getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME) != null || getPresentationValue("SPECIESNAMEPATTERN") != null || getPresentationValue("NLSPECIESNAMEPATTERN") != null) {//$NON-NLS-1$//$NON-NLS-2$
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("ExistingSpeciesOverview")) { //$NON-NLS-1$
			processSelectionPresentation();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "ExistingSpeciesOverview"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ExistingSpeciesDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}