package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.*;

/**
 * The function to manage an existing species
 * 
 * @author Erwin
 */
public class ExistingSpeciesManage extends BWSpeciesFunction {

	/**
	 * @throws WaarException
	 * 
	 */
	private void processOK ( ) throws WaarException {

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			ExistingSpecies species = (ExistingSpecies) getFromFunctionContextMandatory(BWDBRELVARNAMES.EXISTINGSPECIES);
			ExistingSpecies oldSpecies = (ExistingSpecies) species.getPreUpdateState();
			String newSpeciesName = ((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME)).getString();
			LinkedList<Object> commands = new LinkedList<Object>();
			WaarValue language_wv = getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
			WaarValue nlName_wv = getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME);
			if (!newSpeciesName.equals(species.getName())) {
				// species rename requested, do the rename, ignore other fields

				if (language_wv != null || nlName_wv != null) {
					throw new CannotEnterNLNamesWhileRenamingException(getUserLocale());
				}

				species.setName(newSpeciesName);
				try {
					commands.addLast(species.dbUpdateCommand(BWDBRELVARNAMES.EXISTINGSPECIES));
				} catch (NoUpdatesException e) {
					// impossible due to the previous setName
					throw new RuntimeException(e);
				}

				commands.addLast("UPDATE " + BWDBRELVARNAMES.NLSPECIESNAME + ",RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",EQ(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",STRING(" + BracketParser.meta(oldSpecies.getName()) + ")))," + BWDBATTRIBUTENAMES.SPECIESNAME + "(STRING(" + BracketParser.meta(newSpeciesName) + "))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

				if (!((LogicalValue) getPresentationValue("ISALSOPOSSIBLE")).getValue()) { //$NON-NLS-1$
					commands.addLast(oldSpecies.dbUnAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
				}
				commands.addLast("UPDATE " + BWDBRELVARNAMES.POSSIBLESPECIES + ",RESTRICT(" + BWDBRELVARNAMES.POSSIBLESPECIES + ",EQ(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",STRING(" + BracketParser.meta(oldSpecies.getName()) + ")))," + BWDBATTRIBUTENAMES.SPECIESNAME + "(STRING(" + BracketParser.meta(newSpeciesName) + "))"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

				if (((LogicalValue) getPresentationValue("ISALSOPOSSIBLE")).getValue()) { //$NON-NLS-1$
					commands.addLast(species.dbAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
				}
			} else {
				if (((LogicalValue) getPresentationValue("ISALSOPOSSIBLE")).getValue()) { //$NON-NLS-1$
					commands.addLast(species.dbAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
				} else {
					commands.addLast(species.dbUnAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
				}
				if (language_wv != null) {
					if (nlName_wv != null) {
						commands.addLast("UPDATE " + BWDBRELVARNAMES.NLSPECIESNAME + ",RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",AND(EQ(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",STRING(" + BracketParser.meta(species.getName()) + ")),EQ(LANGUAGE,LANGUAGE(ISO2(" + ((GenericStringValue) language_wv).getString() + "))))),(" + BWDBATTRIBUTENAMES.NLSPECIESNAME + "(" + BracketParser.meta(((GenericStringValue) nlName_wv).getString()) + "))"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
						commands.addLast(new NLSpeciesName(species.getName(), ((GenericStringValue) language_wv).getString(), ((GenericStringValue) nlName_wv).getString()).dbAssertCommand(BWDBRELVARNAMES.NLSPECIESNAME));
					} else {
						//delete the currently existing name for that language
						commands.addLast("DELETE " + BWDBRELVARNAMES.NLSPECIESNAME + ",RESTRICT(" + BWDBRELVARNAMES.NLSPECIESNAME + ",AND(EQ(" + BWDBATTRIBUTENAMES.SPECIESNAME + ",STRING(" + BracketParser.meta(species.getName()) + ")),EQ(LANGUAGE,LANGUAGE(ISO2(" + ((GenericStringValue) language_wv).getString() + ")))))"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
					}
				} else {
					if (nlName_wv != null) {
						throw new PleaseSpecifyBothLanguageAndNameException(getUserLocale());
					}
				}
			}
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}

		refreshInfo(getMatchingSpecies());
		setPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE, ""); //$NON-NLS-1$
		setPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME, ""); //$NON-NLS-1$
	}

	/**
	 * @throws WaarException
	 * 
	 */
	private void processSelectionPresentation ( ) throws WaarException {

		AbstractRelation r = getMatchingSpecies();

		if (r.size() == 1) {
			setPresentation("ExistingSpeciesManageDetails"); //$NON-NLS-1$
			refreshInfo(r);
		} else {
			setPresentationValue("SPECIESLIST", getWAARListValue("SPECIESLIST", getMatchingSpecies(), new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
		}

	}

	/**
	 * @param r
	 * @throws WAARApplicationException
	 * @throws WaarException
	 */
	private void refreshInfo (AbstractRelation r) throws WAARApplicationException, WaarException {
		ExistingSpecies species;
		try {
			species = r.toObjectCollectionIgnoringMissingSetters(ExistingSpecies.class).iterator().next();
		} catch (ConstructorMissingException e) {
			throw new WAARApplicationException(e, getUserLocale());
		} catch (ClassDoesNotImplementDBObjectException e) {
			throw new WAARApplicationException(e, getUserLocale());
		}
		setPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME, species.getName());
		Tuple t = r.iterator().next();
		setPresentationValue("ISALSOPOSSIBLE", t.value("ISPOSSIBLE")); //$NON-NLS-1$//$NON-NLS-2$

		AbstractRelation nlNames = t.rvaValue("NLSPECIESNAMELIST"); //$NON-NLS-1$
		setPresentationValue("NLSPECIESNAMELIST", getWAARListValue("NLSPECIESNAMELIST", nlNames, new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$

		saveInFunctionContext(BWDBRELVARNAMES.EXISTINGSPECIES, species);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setDefaultLanguageFromUserContext();
		if (getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null || getPresentationValue(BWDBATTRIBUTENAMES.NLSPECIESNAME) != null || getPresentationValue("SPECIESNAMEPATTERN") != null || getPresentationValue("NLSPECIESNAMEPATTERN") != null) {//$NON-NLS-1$//$NON-NLS-2$
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("ExistingSpeciesOverview")) { //$NON-NLS-1$
			processSelectionPresentation();
		} else {
			processOK();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "ExistingSpeciesOverview"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "ExistingSpeciesManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}