/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.util.HashMap;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.DuplicateNameException;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NoClosingBracketException;

/**
 * @author Erwin
 * 
 */
public final class NLSpeciesName extends AbstractUpdatableDBObject implements DBObjectToNlspeciesname, DBObjectToExistingspecies, ExistingspeciesToDBObject, NlspeciesnameToDBObject {

	/**
	 * 
	 */
	private String language;

	/**
	 * 
	 */
	private String name;

	/**
	 * 
	 */
	private String nlName;

	/**
	 * 
	 */
	private NLSpeciesName preUpdateState;

	/**
	 * Creates the NLSpeciesName
	 */
	public NLSpeciesName ( ) {
		this("", "", ""); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/**
	 * Creates the NLSpeciesName
	 * 
	 * @param name
	 * @param language
	 * @param nlName
	 */
	public NLSpeciesName (String name, String language, String nlName) {
		this.name = name;
//		this.language = language;
		setLanguage(language);
		this.nlName = nlName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.DBObjectToExistingspecies#getExistingspeciesSpeciesname()
	 */
	@Override
	public String getExistingspeciesSpeciesname ( ) {
		return BracketParser.meta(name);
	}

	/**
	 * Gets language
	 *
	 * @return language.
	 */
	public final String getLanguage ( ) {
		return language;
	}

	/**
	 * Gets name
	 *
	 * @return name.
	 */
	public final String getName ( ) {
		return name;
	}

	/**
	 * Gets nlName
	 *
	 * @return nlName.
	 */
	public final String getNlName ( ) {
		return nlName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.DBObjectToNlspeciesname#getNlspeciesnameLanguage()
	 */
	@Override
	public String getNlspeciesnameLanguage ( ) {
		return "ISO2(" + language + ")";  //$NON-NLS-1$//$NON-NLS-2$   Needs LANGUAGE for a component name !!!
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.DBObjectToNlspeciesname#getNlspeciesnameNlspeciesname()
	 */
	@Override
	public String getNlspeciesnameNlspeciesname ( ) {
		return BracketParser.meta(nlName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.DBObjectToNlspeciesname#getNlspeciesnameSpeciesname()
	 */
	@Override
	public String getNlspeciesnameSpeciesname ( ) {
		return BracketParser.meta(name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Sets language
	 *
	 * @param language The language to set.
	 */
	public final void setLanguage (String language) {
//		this.language = language;
		setLanguageFromDB(language);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.NlspeciesnameToDBObject#setLanguageFromDB(java.lang.String)
	 */
	@Override
	public void setLanguageFromDB (String language) {
		try {
			HashMap<String, String> x = BracketParser.createMapFromEscaped(language);
			if (x.size() == 1 && x.keySet().iterator().next().equalsIgnoreCase("ISO2")) { //$NON-NLS-1$
				this.language = x.values().iterator().next();
			} else {
				this.language = language;
			}
		} catch (NoClosingBracketException e) {
			this.language = language;
		} catch (InvalidEscapedCharacterException e) {
			this.language = language;
		} catch (MissingEscapedCharacterException e) {
			this.language = language;
		} catch (DuplicateNameException e) {
			this.language = language;
		}
	}

	/**
	 * Sets name
	 *
	 * @param name The name to set.
	 */
	public final void setName (String name) {
		this.name = name;
	}

	/**
	 * Sets nlName
	 *
	 * @param nlName The nlName to set.
	 */
	public final void setNlName (String nlName) {
		this.nlName = nlName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.NlspeciesnameToDBObject#setNlspeciesnameFromDB(java.lang.String)
	 */
	@Override
	public void setNlspeciesnameFromDB (String nlspeciesname) {
		this.nlName = BracketParser.unMetaWithoutException(nlspeciesname);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new NLSpeciesName(name, language, nlName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.tests.birdwatching.ExistingspeciesToDBObject#setSpeciesnameFromDB(java.lang.String)
	 */
	@Override
	public void setSpeciesnameFromDB (String speciesname) {
		this.name = BracketParser.unMetaWithoutException(speciesname);
	}

}
