package be.SIRAPRISE.birdwatcher;

import java.util.LinkedList;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.WAAR.PresentationLayer.*;

/**
 * The function to create a new existing species
 * 
 * @author Erwin
 */
public class PossibleSpeciesCreate extends BWWebClientFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		LinkedList<DmlAssignmentCommand> commands = new LinkedList<DmlAssignmentCommand>();
		commands.add(new ExistingSpecies(((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME)).getString()).dbAddCommand(BWDBRELVARNAMES.POSSIBLESPECIES));

		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "PossibleSpecies"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "PossibleSpeciesCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}