/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.util.Date;
import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.WAAR.PresentationLayer.ISODateFormat;

/**
 * @author Erwin
 * 
 */
public final class Spot extends AbstractUpdatableDBObject implements DBObjectToSpots, DBObjectToGspots, SpotsToDBObject, GspotsToDBObject {

	/**
	 * 
	 */
	private char gender;

	/**
	 * 
	 */
	private Spot preUpdateState;

	/**
	 * 
	 */
	private String speciesName;

	/**
	 * 
	 */
	private int spotCount;

	/**
	 * 
	 */
	private Date walkDate;

	/**
	 * Creates the Spot
	 */
	public Spot ( ) {
		this(null, "", -1, ' '); //$NON-NLS-1$
	}

	/**
	 * Creates the Spot
	 * 
	 * @param walkDate
	 * @param speciesName
	 * @param spotCount
	 * @param gender
	 */
	public Spot (Date walkDate, String speciesName, int spotCount, char gender) {
		this.walkDate = walkDate;
		this.speciesName = speciesName;
		this.spotCount = spotCount;
		this.gender = gender;
	}

	/**
	 * Gets gender
	 * 
	 * @return gender.
	 */
	public final char getGender ( ) {
		return gender;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToGspots#getGspotsGender()
	 */
	@Override
	public String getGspotsGender ( ) {
		return Character.toString(gender);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToGspots#getGspotsSpeciesname()
	 */
	@Override
	public String getGspotsSpeciesname ( ) {
		return BracketParser.meta(speciesName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToGspots#getGspotsSpotcount()
	 */
	@Override
	public String getGspotsSpotcount ( ) {
		return Integer.toString(spotCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToGspots#getGspotsWalkdate()
	 */
	@Override
	public String getGspotsWalkdate ( ) {
		return ISODateFormat.formatISO(walkDate);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets speciesName
	 * 
	 * @return speciesName.
	 */
	public final String getSpeciesName ( ) {
		return speciesName;
	}

	/**
	 * Gets spotCount
	 * 
	 * @return spotCount.
	 */
	public final int getSpotCount ( ) {
		return spotCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToSpots#getSpotsSpeciesname()
	 */
	@Override
	public String getSpotsSpeciesname ( ) {
		return BracketParser.meta(speciesName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToSpots#getSpotsSpotcount()
	 */
	@Override
	public String getSpotsSpotcount ( ) {
		return Integer.toString(spotCount);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.SpotsToDBObject#setSpeciesnameFromDB(java.lang.String)
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToSpots#getSpotsWalkdate()
	 */
	@Override
	public String getSpotsWalkdate ( ) {
		return ISODateFormat.formatISO(walkDate);
	}

	/**
	 * Gets walkDate
	 * 
	 * @return walkDate.
	 */
	public final Date getWalkDate ( ) {
		return walkDate;
	}

	/**
	 * Sets gender
	 * 
	 * @param gender
	 *            The gender to set.
	 */
	public final void setGender (char gender) {
		this.gender = gender;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.GspotsToDBObject#setGenderFromDB(java.lang.String)
	 */
	@Override
	public void setGenderFromDB (String gender) {
		this.gender = gender.charAt(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new Spot(walkDate, speciesName, spotCount, gender);
	}

	/**
	 * Sets speciesName
	 * 
	 * @param speciesName
	 *            The speciesName to set.
	 */
	public final void setSpeciesName (String speciesName) {
		this.speciesName = speciesName;
	}

	@Override
	public void setSpeciesnameFromDB (String speciesname) {
		this.speciesName = BracketParser.unMetaWithoutException(speciesname);
	}

	/**
	 * Sets spotCount
	 * 
	 * @param spotCount
	 *            The spotCount to set.
	 */
	public final void setSpotCount (int spotCount) {
		this.spotCount = spotCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.SpotsToDBObject#setSpotcountFromDB(java.lang.String)
	 */
	@Override
	public void setSpotcountFromDB (String spotcount) {
		this.spotCount = Integer.parseInt(spotcount);
	}

	/**
	 * Sets walkDate
	 * 
	 * @param walkDate
	 *            The walkDate to set.
	 */
	public final void setWalkDate (Date walkDate) {
		this.walkDate = walkDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.SpotsToDBObject#setWalkdateFromDB(java.lang.String)
	 */
	@Override
	public void setWalkdateFromDB (String walkdate) {
		this.walkDate = ISODateFormat.parseISO(walkdate);
	}
}
