package be.SIRAPRISE.birdwatcher;

import java.util.Date;
import java.util.LinkedList;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.WAAR.PresentationLayer.*;

/**
 * The function to create a new existing species
 * 
 * @author Erwin
 */
public class SpotsCreate extends BWSpotsFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		Object walkDate = getFromSessionContext(BWDBATTRIBUTENAMES.WALKDATE);
		if (walkDate instanceof GenericDateValue) {
			setPresentationValue(BWDBATTRIBUTENAMES.WALKDATE, (GenericDateValue) walkDate);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		String speciesName = ((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME)).getString();
		Date walkDate = ((GenericDateValue) getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE)).getDate();
		int spotCount = ((GenericIntegerValue) getPresentationValue(BWDBATTRIBUTENAMES.SPOTCOUNT)).getInteger();

		LinkedList<DmlAssignmentCommand> commands = new LinkedList<DmlAssignmentCommand>();

		if (((LogicalValue) getPresentationValue("FWALKDATE")).getValue()) { //$NON-NLS-1$
			commands.add(new Walk(walkDate).dbAssertCommand(BWDBRELVARNAMES.WALK));
		}

		if (((LogicalValue) getPresentationValue("FSPECIESNAME")).getValue()) { //$NON-NLS-1$
			commands.add(new ExistingSpecies(speciesName).dbAssertCommand(BWDBRELVARNAMES.POSSIBLESPECIES));
		}

		String gender = ((GenericStringValue) getPresentationValue(BWDBATTRIBUTENAMES.GENDER)).getString();
		if (gender.equalsIgnoreCase("-") || gender.equalsIgnoreCase(" ")) { //$NON-NLS-1$ //$NON-NLS-2$
			commands.add(new Spot(walkDate, speciesName, spotCount, ' ').dbAddCommand(BWDBRELVARNAMES.SPOTS));
		} else {
			commands.add(new Spot(walkDate, speciesName, spotCount, gender.charAt(0)).dbAddCommand(BWDBRELVARNAMES.GSPOTS));
		}
		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "SpotsCreate.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return true;
	}
}