package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class SpotsDelete extends BWSpotsFunction {

	/**
	 * 
	 */
	private boolean leave;

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setDefaultLanguageFromUserContext();
		if (getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null || getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE) != null || getPresentationValue("FROMDATE") != null || getPresentationValue("TODATE") != null || getPresentationValue("FROMCOUNT") != null || getPresentationValue("TOCOUNT") != null) { //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			processSelectionPresentation();
		}
	}

	/**
	 * @throws Problem
	 * @throws PresentationNotSetException
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		AbstractRelation r = getMatchingSpots();
		if (r.size() == 1) {
			try {
				Spot spot = r.toObjectCollectionIgnoringMissingSetters(Spot.class).iterator().next();
				setPresentation("SpotsDeleteConfirm"); //$NON-NLS-1$
				setPresentationValue(BWDBATTRIBUTENAMES.WALKDATE, new GenericDateValue(spot.getWalkDate()));
				setPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME, spot.getSpeciesName());
				setPresentationValue(BWDBATTRIBUTENAMES.SPOTCOUNT, spot.getSpotCount());
				setPresentationValue(BWDBATTRIBUTENAMES.GENDER, spot.getGender());

				saveInFunctionContext(BWDBRELVARNAMES.SPOTS, spot);
			} catch (ConstructorMissingException e) {
				throw new RuntimeException(e);
			} catch (ClassDoesNotImplementDBObjectException e) {
				throw new RuntimeException(e);
			}
		} else {
			setPresentationValue("SPOTSLIST", getWAARListValue("SPOTSLIST", r, new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("SpotsOverview")) { //$NON-NLS-1$
			processSelectionPresentation();
		} else {
			Spot spot = (Spot) getFromFunctionContextMandatory(BWDBRELVARNAMES.SPOTS);

			DBConnection dbc = getDBConnection(getUserLocale());
			try {
				dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execDmlCommandAndEndTransaction(spot.dbDeleteCommand(spot.getGender() == ' ' ? BWDBRELVARNAMES.SPOTS : BWDBRELVARNAMES.GSPOTS)); //$NON-NLS-1$
				leave = true;
			} catch (ConnectionClosedException e) {
				log(e);
				throw new Problem(e, getUserLocale());
			} catch (ErrorMessageException e) {
				log(e);
				throw new Problem(e, getUserLocale());
			} finally {
				dbc.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "SpotsOverview"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "SpotsDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}