/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;

/**
 * @author Erwin
 * 
 */
public final class Walk extends AbstractUpdatableDBObject implements DBObjectToWalk, WalkToDBObject {

	/**
	 * 
	 */
	private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd"); //$NON-NLS-1$

	/**
	 * 
	 */
	private Walk preUpdateState;

	/**
	 * 
	 */
	private Date walkDate;
	
	/**
	 * Creates the Walk
	 */
	public Walk ( ) {
		
	}

	/**
	 * Creates the Walk
	 * 
	 * @param walkDate
	 */
	public Walk (Date walkDate) {
		this.walkDate = walkDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#getPreUpdateState()
	 */
	@Override
	public UpdatableDBObject getPreUpdateState ( ) {
		return preUpdateState;
	}

	/**
	 * Gets walkDate
	 *
	 * @return walkDate.
	 */
	public final Date getWalkDate ( ) {
		return walkDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.DBObjectToWalk#getWalkWalkdate()
	 */
	@Override
	public String getWalkWalkdate ( ) {
		return simpleDateFormat.format(walkDate);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.client.UpdatableDBObject#setPreUpdateState()
	 */
	@Override
	public void setPreUpdateState ( ) {
		this.preUpdateState = new Walk(walkDate);
	}

	/**
	 * Sets walkDate
	 *
	 * @param walkDate The walkDate to set.
	 */
	public final void setWalkDate (Date walkDate) {
		this.walkDate = walkDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.birdwatcher.WalkToDBObject#setWalkdateFromDB(java.lang.String)
	 */
	@Override
	public void setWalkdateFromDB (String walkdate) {
		try {
			this.walkDate = simpleDateFormat.parse(walkdate);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

}
