/**
 * 
 */
package be.SIRAPRISE.birdwatcher;

import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.WAAR.PresentationLayer.GenericDateValue;
import be.WAAR.PresentationLayer.WaarException;

/**
 * @author Erwin
 * 
 */
public final class WalksCreate extends BWWalksFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.OnLinePresentationFunction#doInitialLogic()
	 */
	@Override
	public void doInitialLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.OnLinePresentationFunction#doPresentationLogic()
	 */
	@Override
	public void doPresentationLogic ( ) throws WaarException {
		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			GenericDateValue walkDate = (GenericDateValue) getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE);
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execDmlCommandAndEndTransaction(new Walk(walkDate.getDate()).dbAddCommand(BWDBRELVARNAMES.WALK)); //$NON-NLS-1$
			saveInSessionContext(BWDBATTRIBUTENAMES.WALKDATE, walkDate);
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.OnLinePresentationFunction#doResumeLogic()
	 */
	@Override
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.OnLinePresentationFunction#getInitialPresentationName()
	 */
	@Override
	public String getInitialPresentationName ( ) {
		return "Walk"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.OnLinePresentationFunction#getPresentationFunctionDescription(java.lang.String)
	 */
	@Override
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "WalksCreate.Text"); //$NON-NLS-1$
	}

}
