package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class WalksDelete extends BWWalksFunction {

	/**
	 * 
	 */
	private boolean leave = false;

	/**
	 * @throws WaarException
	 * 
	 */
	private void processDeleteConfirmation ( ) throws WaarException {

		Walk walk = (Walk) getFromFunctionContextMandatory(BWDBRELVARNAMES.WALK);
		LinkedList<Object> commands = new LinkedList<Object>();
		String dateCondition = "EQ(" + BWDBATTRIBUTENAMES.WALKDATE + ",DATE(" + ISODateFormat.formatISO(walk.getWalkDate()) + "))"; //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
		commands.addLast(walk.dbDeleteCommand(BWDBRELVARNAMES.WALK));
		commands.addLast("DELETE " + BWDBRELVARNAMES.SPOTS + ",RESTRICT(" + BWDBRELVARNAMES.SPOTS + "," + dateCondition + ")");    //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		commands.addLast("DELETE " + BWDBRELVARNAMES.GSPOTS + ",RESTRICT(" + BWDBRELVARNAMES.GSPOTS + "," + dateCondition + ")");    //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
		DBConnection dbc = getDBConnection(getUserLocale());
		try {
			dbc.startTransaction(getUserData().getUserID(), true, "", new byte[] {}, TransactionMode.UPDATE).execMultipleStatementAndEndTransaction(commands); //$NON-NLS-1$
			leave = true;
		} catch (ConnectionClosedException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} catch (ErrorMessageException e) {
			log(e);
			throw new Problem(e, getUserLocale());
		} finally {
			dbc.close();
		}

	}

	/**
	 * @throws Problem
	 * @throws PresentationNotSetException
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		AbstractRelation r = getMatchingWalks();
		if (r.size() == 1) {
			try {
				Walk walk = r.toObjectCollectionIgnoringMissingSetters(Walk.class).iterator().next();

				GenericDateValue wv_walkDate = new GenericDateValue(walk.getWalkDate());
				WaarValue wv_language = getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
				setPresentation("WalksDeleteConfirm"); //$NON-NLS-1$
				setPresentationValue(BWDBATTRIBUTENAMES.WALKDATE, wv_walkDate);
				setPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE, wv_language);
				setPresentationValue("SPOTSLIST", getWAARListValue("SPOTSLIST", getMatchingSpots(), new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$

				saveInFunctionContext(BWDBRELVARNAMES.WALK, walk);
			} catch (ConstructorMissingException e) {
				throw new RuntimeException(e);
			} catch (ClassDoesNotImplementDBObjectException e) {
				throw new RuntimeException(e);
			}
		} else {
			setPresentationValue("WALKSLIST", getWAARListValue("WALKSLIST", r, new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setDefaultLanguageFromUserContext();

		if (getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE) != null || getPresentationValue("FROMDATE") != null || getPresentationValue("TODATE") != null || getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null) { //$NON-NLS-1$ //$NON-NLS-2$
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("WalksOverview")) { //$NON-NLS-1$
			processSelectionPresentation();
		} else {
			processDeleteConfirmation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "WalksOverview"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "WalksDelete.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return leave;
	}
}