package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;

import be.SIRAPRISE.client.AbstractRelation;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class WalksManage extends BWWalksFunction {

	/**
	 * @throws Problem
	 * @throws PresentationNotSetException
	 * @throws WaarException
	 */
	private void processSelectionPresentation ( ) throws WaarException {
		AbstractRelation r = getMatchingWalks();
		if (r.size() == 1) {
			GenericDateValue wv_walkDate = new GenericDateValue(ISODateFormat.parseISO(r.iterator().next().value(BWDBATTRIBUTENAMES.WALKDATE)));
			WaarValue wv_language = getPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE);
			setPresentation("WalksManageDetails"); //$NON-NLS-1$
			setPresentationValue(BWDBATTRIBUTENAMES.WALKDATE, wv_walkDate);
			setPresentationValue(BWDBATTRIBUTENAMES.LANGUAGE, wv_language);
			refreshInfo();
		} else {
			setPresentationValue("WALKSLIST", getWAARListValue("WALKSLIST", r, new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * @throws WaarException
	 * 
	 */
	private void refreshInfo ( ) throws WaarException {
		setPresentationValue("SPOTSLIST", getWAARListValue("SPOTSLIST", getMatchingSpots(), new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) throws WaarException {
		setDefaultLanguageFromUserContext();
		
		if (getPresentationValue(BWDBATTRIBUTENAMES.WALKDATE) != null || getPresentationValue("FROMDATE") != null || getPresentationValue("TODATE") != null || getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null ) { //$NON-NLS-1$ //$NON-NLS-2$
			processSelectionPresentation();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		if (getPresentation().getName().equalsIgnoreCase("WalksOverview")) { //$NON-NLS-1$
			processSelectionPresentation();
		} else {
			refreshInfo();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
		doPresentationLogic();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return "WalksOverview"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "WalksManage.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}