package be.SIRAPRISE.birdwatcher;

import java.util.Arrays;
import java.util.HashSet;
import be.WAAR.PresentationLayer.*;

/**
 * The function to produce an overview of defined attributes
 * 
 * @author Erwin
 */
public class WalksOverview extends BWWalksFunction {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doInitialLogic()
	 */
	public void doInitialLogic ( ) {
		setDefaultLanguageFromUserContext();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doPresentationLogic()
	 */
	public void doPresentationLogic ( ) throws WaarException {
		setPresentationValue("WALKSLIST", getWAARListValue("WALKSLIST", getMatchingWalks(), new HashSet<String>(Arrays.asList(new String[] { BWDBATTRIBUTENAMES.SPECIESNAME, BWDBATTRIBUTENAMES.NLSPECIESNAME })))); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#doResumeLogic()
	 */
	public void doResumeLogic ( ) throws WaarException {
//		if (getPresentationValue(BWDBATTRIBUTENAMES.SPECIESNAME) != null || getPresentationValue("FROMDATE") != null || getPresentationValue("TODATE") != null) { //$NON-NLS-1$//$NON-NLS-2$
			doPresentationLogic();
//		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getInitialPresentationName()
	 */
	public String getInitialPresentationName ( ) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#getPresentationFunctionDescription()
	 */
	public String getPresentationFunctionDescription (String language) {
		return I18N.getString(getUserLocale(), "WalksOverview.Text"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.fgov.kszbcss.WAAR.OnLinePresentationFunction#leaveFunctionOnExit()
	 */
	public boolean leaveFunctionOnExit ( ) {
		return false;
	}
}