/*
 * Created on 18-sep-2007
 */
package be.WAAR.PresentationLayer;

/**
 * An ArchitectureValueGetter has a method to retrieve a Presentation Value for some field managed by the architecture from a user function. The context of a specific user function is often needed, e.g. for retrieving the application name of the function, or for retrieving the user's preferred Date and Time formatting to format the System date and time.
 * 
 * @author Erwin Smout
 */
abstract class ArchitectureValueGetter {

	/**
	 * Gets the value for the specific Architecture field that this Getter is for, taking the given user function into account.
	 * 
	 * @param userFunction
	 *            The given userFunction
	 * @return The appropriate value (i.e. corresponding to the semantics of the specific getter) from/for this particular userFunction
	 */
	abstract String getValue (OnLinePresentationFunction userFunction);

}
