/*
 * Created on 18-sep-2007
 */
package be.WAAR.PresentationLayer;

import java.sql.Date;

/**
 * The System Date value getter extracts the UserData object from the userFunction, and formats the current System Date at the server in the user's preferred date format. If no UserData can be obtained (e.g. during logon !!!), then the ISO date format is used.
 * 
 * @author Erwin Smout
 */
class ArchitectureValueGetterForDate extends ArchitectureValueGetter {

	/**
	 * The instance
	 */
	private static ArchitectureValueGetter instance = new ArchitectureValueGetterForDate();

	/**
	 * Gets the instance
	 * 
	 * @return the instance
	 */
	static ArchitectureValueGetter getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private ArchitectureValueGetterForDate ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.ArchitectureValueGetter#getValue(be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction)
	 */
	String getValue (OnLinePresentationFunction userFunction) {
		UserData userData = userFunction.getUserData();
		if (userData == null) {
			return ISODateFormat.formatISO(new Date(System.currentTimeMillis()));
		} else {
			return userData.getPreferredDateFormat().format(new Date(System.currentTimeMillis()));
		}
	}
}
