/*
 * Created on 18-sep-2007
 */
package be.WAAR.PresentationLayer;

/**
 * The PresentationFunction valuegetter extracts the Description from the user function.
 * 
 * @author Erwin Smout
 */
class ArchitectureValueGetterForPresentationFunction extends ArchitectureValueGetter {

	/**
	 * The instance
	 */
	private static ArchitectureValueGetter instance = new ArchitectureValueGetterForPresentationFunction();

	/**
	 * Gets The instance
	 * 
	 * @return The instance
	 */
	static ArchitectureValueGetter getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private ArchitectureValueGetterForPresentationFunction ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.ArchitectureValueGetter#getValue(be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction)
	 */
	String getValue (OnLinePresentationFunction userFunction) {
		UserData userData = userFunction.getUserData();
		if (userData != null) {
			return userFunction.getPresentationFunctionDescription(userData.getUserLanguage().getString());
		} else {
			return userFunction.getPresentationFunctionDescription(Architecture.getDefaultLocale().getLanguage());
		}
	}
}
