/*
 * Created on 18-sep-2007
 */
package be.WAAR.PresentationLayer;

import java.sql.Date;

/**
 * The SystemTime valuegetter extracts the userdata from the user function, and then uses the user's preferred Date format to format the system time (at the server's site). If no userdata could be obtained (e.g. during logon !!!), then the ISO format is used.
 * 
 * @author Erwin Smout
 */
class ArchitectureValueGetterForTime extends ArchitectureValueGetter {

	/**
	 * The instance
	 */
	private static ArchitectureValueGetter instance = new ArchitectureValueGetterForTime();

	/**
	 * Gets The instance
	 * 
	 * @return The instance
	 */
	static ArchitectureValueGetter getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private ArchitectureValueGetterForTime ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.ArchitectureValueGetter#getValue(be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction)
	 */
	String getValue (OnLinePresentationFunction userFunction) {
		UserData userData = userFunction.getUserData();
		if (userData == null) {
			return ISOTimeFormat.formatISO(new Date(System.currentTimeMillis()));
		} else {
			return userData.getPreferredTimeFormat().format(new Date(System.currentTimeMillis()));
		}
	}
}
