/*
 * Created on 18-sep-2007
 */
package be.WAAR.PresentationLayer;

/**
 * The UserID valuegetter extracts the user ID from the user Function's UserData object. If there is no such object (e.g. during logon !!!), then the empty string is returned.
 * 
 * @author Erwin Smout
 */
class ArchitectureValueGetterForUserid extends ArchitectureValueGetter {

	/**
	 * The instance
	 */
	private static ArchitectureValueGetter instance = new ArchitectureValueGetterForUserid();

	/**
	 * Gets The instance
	 * 
	 * @return The instance
	 */
	static ArchitectureValueGetter getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private ArchitectureValueGetterForUserid ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.ArchitectureValueGetter#getValue(be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction)
	 */
	String getValue (OnLinePresentationFunction userFunction) {
		UserData userData = userFunction.getUserData();
		if (userData != null) {
			return userData.getUserID();
		} else {
			return ""; //$NON-NLS-1$
		}
	}
}
