package be.WAAR.PresentationLayer;

import java.sql.*;
import java.util.logging.Logger;

/**
 * @author Erwin
 */
public abstract class BatchPresentationFunction extends PresentationFunction implements Runnable {

	/**
	 * 
	 */
	static int DEFAULTCOMMITCOUNT = 50;

	/**
	 * 
	 */
	private int commitcount;

	/**
	 * 
	 */
	public BatchPresentationFunction ( ) {
		initialize(DEFAULTCOMMITCOUNT);
	}

	/**
	 * @param commitcount
	 */
	public BatchPresentationFunction (int commitcount) {
		initialize(commitcount);
	}

	/**
	 * @param c
	 * @throws Error
	 * 
	 */
	private void initialize (int c) throws Error {
		this.commitcount = c;
		BatchPresentationProperties rtp = BatchPresentationProperties.getInstance();
		Driver d;
		try {
			setUserData(new UserData(rtp.getRunTimeProperty("UserID"), rtp.getRunTimeProperty("UserDateFormat"), rtp.getRunTimeProperty("UserTimeFormat"), new GenericStringValue(rtp.getRunTimeProperty("UserLanguage")))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			d = (Driver) Class.forName(rtp.getRunTimeProperty("DB2DriverName")).newInstance(); //$NON-NLS-1$
			DriverManager.registerDriver(d);
			Connection connection = DriverManager.getConnection(rtp.getRunTimeProperty("DatabaseSystem"), rtp.getRunTimeProperty("UserID"), rtp.getRunTimeProperty("UserPassword")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			connection.setAutoCommit(false);
			PreparedStatement setSQLID = connection.prepareStatement("SET CURRENT SQLID = '" + BatchPresentationProperties.getInstance().getRunTimeProperty("DBOWNER") + "'"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			setSQLID.execute();
			// getDbLink().setConnection(connection);
		} catch (InstantiationException e) {
			e.printStackTrace(System.err);
			throw new Error();
		} catch (IllegalAccessException e) {
			e.printStackTrace(System.err);
			throw new Error();
		} catch (ClassNotFoundException e) {
			e.printStackTrace(System.err);
			throw new Error();
		} catch (SQLException e) {
			e.printStackTrace(System.err);
			throw new Error();
		} catch (WaarException e) {
			e.printStackTrace(System.err);
			throw new Error();
		}
	}

	/**
	 * 
	 */
	public final void commit ( ) {

	}

	/**
	 * @return the commit count
	 */
	public final int getCommitcount ( ) {
		return commitcount;
	}

	/**
	 * @throws Exception
	 */
	public abstract void process ( ) throws Exception;

	/**
	 * 
	 */
	public final void rollback ( ) {
		// getDbLink().rollback();
	}

	/**
	 * 
	 */
	public final void run ( ) {
		try {
			process();
		} catch (Throwable e) {
			Logger.getLogger(this.getClass().getName()).severe(e.getClass().getName() + (e.getMessage() == null ? "" : (":" + e.getMessage()))); //$NON-NLS-1$//$NON-NLS-2$
			e.printStackTrace(System.err);
			// getDbLink().rollback();
		} finally {
		}
	}
}
