package be.WAAR.PresentationLayer;

import java.io.*;
import java.util.Properties;

/**
 * @author Erwin
 */
public class BatchPresentationProperties {

	/**
	 * 
	 */
	private static BatchPresentationProperties instance = new BatchPresentationProperties();

	/**
	 * @return the instance of the properties
	 */
	public static BatchPresentationProperties getInstance ( ) {
		return instance;
	}

	/**
	 * 
	 */
	private Properties runTimeProperties;

	/**
	 * singleton
	 */
	private BatchPresentationProperties ( ) {

	}

	/**
	 * @param property
	 * @return the requested property
	 */
	public String getRunTimeProperty (String property) {
		if (runTimeProperties == null) {
			File f = new File(Architecture.waarHomeDirectory + File.separatorChar + "RunTimeProperties"); //$NON-NLS-1$
			runTimeProperties = new Properties();
			try {
				runTimeProperties.load(new FileInputStream(f));
			} catch (FileNotFoundException e) {
				e.printStackTrace(System.err);
				throw new RuntimeException("File RunTimeProperties was not found", e); //$NON-NLS-1$
			} catch (IOException e) {
				e.printStackTrace(System.err);
				throw new RuntimeException("I/O error when loading Runtime properties", e); //$NON-NLS-1$
			}
		}
		return runTimeProperties.getProperty(property);
	}
}
