/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

/**
 * @author Erwin
 * 
 */
final class CheckBoxRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new CheckBoxRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the CheckBoxRenderer
	 * 
	 */
	private CheckBoxRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		return "<INPUT type=\"checkbox\" name=\"" + presentationField.getName() + "\"" + (presentationField.isInputEnabled() ? "" : "disabled=\"true\"") + getHTMLTabIndexSpec(presentationField) + ">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		if (presentationFieldValue instanceof LogicalValue) {
			StringBuilder fieldHtml = new StringBuilder(80).append("<INPUT type=\"checkbox\" name=\"" + presentationField.getName() + "\""); //$NON-NLS-1$//$NON-NLS-2$
			LogicalValue logicalValue = (LogicalValue) presentationFieldValue;
			if (logicalValue.getValue()) {
				fieldHtml.append(" CHECKED "); //$NON-NLS-1$
			}
			if (!presentationField.isInputEnabled()) {
				fieldHtml.append(" disabled=\"true\" "); //$NON-NLS-1$
			}
			fieldHtml.append(getHTMLTabIndexSpec(presentationField)).append(">"); //$NON-NLS-1$
			return fieldHtml.toString();
		} else {
			throw new IllegalArgumentException(presentationFieldValue.getClass().getName());
		}
	}

}
