/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Erwin
 * 
 */
final class ComboBoxRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new ComboBoxRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the ComboBoxRenderer
	 * 
	 */
	private ComboBoxRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		if (presentationField.isInputEnabled()) {
			PresentationType presentationFieldType = presentationField.getType();
			if (presentationFieldType instanceof TextsEnumerationType) {
				Map<String, String> valuesAndLabels = ((TextsEnumerationType) presentationFieldType).getValuesAndLabels();
				String htmlFieldValue = "<SELECT NAME=\"" + presentationField.getName() + "\">"; //$NON-NLS-1$ //$NON-NLS-2$
				for (Entry<String, String> me : valuesAndLabels.entrySet()) {
					htmlFieldValue += ("<OPTION VALUE=\"" + me.getKey() + "\">" + me.getValue() + "</OPTION>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
				}
				htmlFieldValue += "</SELECT>"; //$NON-NLS-1$
				return htmlFieldValue;
			} else {
				if (presentationFieldType instanceof NumberedEnumerationType) {
					String[] labels = ((NumberedEnumerationType) presentationFieldType).getLabels();
					String htmlFieldValue = "<SELECT NAME=\"" + presentationField.getName() + "\">"; //$NON-NLS-1$ //$NON-NLS-2$
					int i = 1;
					for (String label : labels) {
						htmlFieldValue += ("<OPTION VALUE=\"" + (i++) + "\">" + label + "</OPTION>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$
					}
					htmlFieldValue += "</SELECT>"; //$NON-NLS-1$
					return htmlFieldValue;
				} else {
					throw new IllegalArgumentException(presentationField.getName() + " not of type Enumeration"); //$NON-NLS-1$
				}
			}
		} else {
			return ""; //$NON-NLS-1$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		String stringValue = presentationFieldValue.toWAARString(userFunction.getUserData());
		PresentationType presentationFieldType = presentationField.getType();
		if (presentationField.isInputEnabled()) {
			if (presentationFieldType instanceof TextsEnumerationType) {
				Map<String, String> valuesAndLabels = ((TextsEnumerationType) presentationFieldType).getValuesAndLabels();
				String htmlFieldValue = "<SELECT" + getHTMLControlNameSpec(presentationField) + getHTMLTabIndexSpec(presentationField) + ">"; //$NON-NLS-1$ //$NON-NLS-2$
				for (Entry<String, String> me : valuesAndLabels.entrySet()) {
					String optionValue = me.getKey();
					htmlFieldValue += ("<OPTION VALUE=\"" + optionValue + "\"" + (optionValue.equals(stringValue) ? " selected=\"selected\"" : "") + ">" + me.getValue() + "</OPTION>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
				}
				htmlFieldValue += "</SELECT>"; //$NON-NLS-1$
				return htmlFieldValue;
			} else {
				if (presentationFieldType instanceof NumberedEnumerationType) {
					String[] labels = ((NumberedEnumerationType) presentationFieldType).getLabels();
					String htmlFieldValue = "<SELECT" + getHTMLControlNameSpec(presentationField) + ">"; //$NON-NLS-1$ //$NON-NLS-2$
					int i = 1;
					for (String label : labels) {
						htmlFieldValue += ("<OPTION VALUE=\"" + (i++) + "\"" + (label.equals(stringValue) ? " selected=\"selected\"" : "") + ">" + label + "</OPTION>"); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
					}
					htmlFieldValue += "</SELECT>"; //$NON-NLS-1$
					return htmlFieldValue;
				} else {
					throw new IllegalArgumentException(presentationField.getName() + " not of type Enumeration"); //$NON-NLS-1$
				}
			}
		} else {
			if (presentationFieldType instanceof TextsEnumerationType) {
				return ((TextsEnumerationType) presentationFieldType).getValuesAndLabels().get(stringValue);
			} else {
				if (presentationFieldType instanceof NumberedEnumerationType) {
					return stringValue;
				} else {
					throw new IllegalArgumentException(presentationField.getName() + " not of type Enumeration"); //$NON-NLS-1$
				}
			}
		}
	}
}
