package be.WAAR.PresentationLayer;

import java.io.*;

import javax.naming.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * @version 1.0
 * @author Erwin
 */
public abstract class ContextViewServlet extends HttpServlet implements Servlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7925812282659471814L;

	/**
	 * @param writer
	 * @param ctx
	 * @param name
	 */
	private void printJndiContextAsHtmlList (PrintWriter writer, Context ctx, String name) {
		writer.println("<ul>"); //$NON-NLS-1$
		try {
			NamingEnumeration<Binding> en = ctx.listBindings(""); //$NON-NLS-1$
			while (en != null && en.hasMoreElements()) {
				Binding binding = en.next();
				String name2 = name + ((name.length() > 0) ? "/" : "") + binding.getName(); //$NON-NLS-1$ //$NON-NLS-2$
				writer.println("<li><u>" + name2 + "</u>: " + binding.getClassName() + "</li>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if (binding.getObject() instanceof Context) {
					printJndiContextAsHtmlList(writer, (Context) binding.getObject(), name2);
				}
			}
		} catch (NamingException ex) {
			// Normalerweise zu ignorieren
		}
		writer.println("</ul>"); //$NON-NLS-1$
	}

	/**
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public final void doGet (HttpServletRequest req, HttpServletResponse resp) throws ServletException {
		try {
			PrintWriter writer = resp.getWriter();
			try {
				writer.println("<html><head><title>JNDI-Context-Listing</title></head>"); //$NON-NLS-1$
				writer.println("<body><h3>JNDI-Context-Listing</h3>"); //$NON-NLS-1$
				Context ctx = new InitialContext();
				printJndiContextAsHtmlList(writer, ctx, ""); //$NON-NLS-1$
				ctx.close();
				writer.println("</body>"); //$NON-NLS-1$
				writer.println("</html>"); //$NON-NLS-1$
				writer.flush();
			} catch (Exception ex) {
				throw new ServletException(ex);
			} finally {
				writer.close();
			}
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}

	/**
	 * @see javax.servlet.GenericServlet#getServletInfo()
	 */
	public final String getServletInfo ( ) {
		return this.getClass().getName() + " - " + this.toString(); //$NON-NLS-1$
	}
}