/*
 * Created on 2-aug-2006
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * DynamicColumnList is the Presentation layer attribute type for lists whose columns cannot be defined in the .pres file, and cannot be but obtained from the data that the user function provides
 * 
 * @author Erwin Smout
 */
public class DynamicColumnList extends PresentationType {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.AttributeType#encode(java.lang.String)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
		throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), I18N.getString(locale, "DynamicColumnList.NoEncoding"), locale); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return VariableColumnListRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		return Integer.toString(((DynamicColumnListValue) waarValue).getColumnList().size());
		//		String fieldHtml = ""; //$NON-NLS-1$
		// DynamicColumnListValue dynamicColumnListValue = (DynamicColumnListValue) waarValue;
		//
		// LinkedList<String> columnList = dynamicColumnListValue.getColumnList();
		// int columnCount = Math.max(columnList.size(), 1);
		// int columnWidthPercent = 100 / columnCount;
		//		fieldHtml += "<TR>"; //$NON-NLS-1$
		// Iterator<String> i_columnList = columnList.iterator();
		// while (i_columnList.hasNext()) {
		// String columnName = i_columnList.next();
		//			fieldHtml += "<TH width=\"" + columnWidthPercent + "%\">" + columnName + "</TH>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		// }
		//		fieldHtml += "</TR>"; //$NON-NLS-1$
		//
		// LinkedList<HashMap<String, WaarValue>> rowList = dynamicColumnListValue.getRowList();
		// // iterate over the all the entries in the list
		// Iterator<HashMap<String, WaarValue>> i_rowList = rowList.iterator();
		// while (i_rowList.hasNext()) {
		// // get the valuemap that holds the row
		// HashMap<String, WaarValue> row = i_rowList.next();
		//			StringBuffer rowHtml = new StringBuffer("<TR>"); //$NON-NLS-1$
		// // reset the column iterator
		// i_columnList = columnList.iterator();
		// while (i_columnList.hasNext()) {
		// String columnName = i_columnList.next();
		// WaarValue entryColumnValue = row.get(columnName);
		// if (entryColumnValue != null) {
		// if (entryColumnValue instanceof GenericStringValue) {
		//						rowHtml.append("<TD>" + ((GenericStringValue) entryColumnValue).getString() + "</TD>"); //$NON-NLS-1$ //$NON-NLS-2$
		// } else {
		//						rowHtml.append("<TD><TABLE border=\"1\" width=\"100%\"><TBODY>" + getNakedStringRepresentation(entryColumnValue, userFunction, presentationField, locale) + "</TBODY></TABLE></TD>"); //$NON-NLS-1$ //$NON-NLS-2$
		// }
		// } else {
		//					rowHtml.append("<TD> </TD>"); //$NON-NLS-1$
		// }
		// }
		//			rowHtml.append("</TR>"); //$NON-NLS-1$
		// fieldHtml += rowHtml;
		// }
		//
		// return fieldHtml;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		return VariableColumnListRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof ListValue || value instanceof DynamicColumnListValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}