package be.WAAR.PresentationLayer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

/**
 * @author Erwin
 */
public class DynamicColumnListValue implements WaarValue {

	/**
	 * The list of column names
	 */
	private LinkedList<String> columnList = new LinkedList<String>();

	/**
	 * The list name
	 */
	private String listName;

	/**
	 * The rows
	 */
	private LinkedList<HashMap<String, WaarValue>> rowList = new LinkedList<HashMap<String, WaarValue>>();

	/**
	 * Creates the variable-column list value
	 * 
	 * @param listName
	 *            The name for the listfield
	 */
	public DynamicColumnListValue (String listName) {
		this.listName = listName;
	}

	/**
	 * @param attributeName
	 */
	public void addColumn (String attributeName) {
		columnList.add(attributeName);
	}

	/**
	 * Adds all the column names given in columns to the column list of this value
	 * 
	 * @param columns
	 *            the set of column names
	 */
	public void addColumns (Set<String> columns) {
		columnList.addAll(columns);
	}

	/**
	 * Appends a row value. The map is supposed to correspond to this list's heading.
	 * 
	 * @param map
	 *            A map of column name / presentation values
	 */
	public void append (HashMap<String, WaarValue> map) {
		rowList.addLast(map);
	}

	/**
	 * Gets The list of column names
	 * 
	 * @return The list of column names
	 */
	public LinkedList<String> getColumnList ( ) {
		return columnList;
	}

	/**
	 * @return the list name
	 */
	public String getListName ( ) {
		return listName;
	}

	/**
	 * @return the list
	 */
	public LinkedList<HashMap<String, WaarValue>> getRowList ( ) {
		return rowList;
	}

	public String toString ( ) {
		return rowList.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.WaarValue#toWAARString(be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public String toWAARString (UserData userData) {
		return rowList.toString();
	}
}
