/*
 * Created on 10-sep-2007
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * The exception thrown when the Architecture fails to create a PresentationType instance for a presentation attribute
 * 
 * @author Erwin Smout
 */
class FailedToCreatePresentationTypeException extends WaarException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4083803788245186110L;

	/**
	 * Creates the exception and sets the display message
	 * 
	 * @param e
	 *            The exception that caused the failure
	 * @param typeName
	 *            The name of the presentation type that could not be instantiated
	 * @param locale
	 *            The locale in which to set the message text
	 */
	FailedToCreatePresentationTypeException (Exception e, String typeName, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "FailedToCreatePresentationTypeException.Text"), new String[] { typeName, e.getMessage(), e.getClass().getName() })); //$NON-NLS-1$
	}
}
