package be.WAAR.PresentationLayer;

import java.text.*;
import java.util.Date;
import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * GenericDate is the presentation type for date fields.
 * 
 * @author Erwin
 */
public class GenericDate extends PresentationType {

	/**
	 * 
	 */
	private static final long MILLISECONDSINDAY = 1000 * 60 * 60 * 24;

	/**
	 * @param date
	 * @return
	 */
	public static GenericDateValue fromDate (Date date) {
		return new GenericDateValue(date);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof GenericDateValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
		if (val.length() == 0) {
			return null;
		} else {
			Date d;
			try {
				SimpleDateFormat preferredDateFormat = userData == null ? ISODateFormat.getISODateFormatInstance() : userData.getPreferredDateFormat();
				d = preferredDateFormat.parse(val);
			} catch (ParseException e1) {
				throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), e1.getMessage(), locale);
			}
			return fromDate(d);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		UserData userData = userFunction.getUserData();
		SimpleDateFormat preferredDateFormat = userData == null ? ISODateFormat.getISODateFormatInstance() : userData.getPreferredDateFormat();
		String result = preferredDateFormat.format(((GenericDateValue) waarValue).getDate());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		return fromDate(new Date(v * MILLISECONDSINDAY));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		return new GenericDateValue(new Date(v - (v % MILLISECONDSINDAY)));
	}
}
