package be.WAAR.PresentationLayer;

import java.util.Date;

/**
 * GenericDateValue is the presentation layer value Class for date values
 * 
 * @author Erwin
 */
public class GenericDateValue implements WaarValue {

	/**
	 * The date value
	 */
	private Date date;

	/**
	 * Creates the presentation layer value
	 * 
	 * @param date
	 *            The date value
	 */
	public GenericDateValue (Date date) {
		this.date = date;
	}

	/**
	 * Gets The date value
	 * 
	 * @return The date value
	 */
	public Date getDate ( ) {
		return date;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return date.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.WaarValue#toWAARString(be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public String toWAARString (UserData userData) {
		return userData.getPreferredDateFormat().format(date);
	}
}
