package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin
 */
public class GenericDouble extends PresentationType {

	/**
	 * @param val
	 * @param locale
	 * @return A GenericLongValue holding the long number represented by val
	 * @throws InvalidAttributeValueException
	 */
	public static GenericDoubleValue fromString (String val, Locale locale) throws InvalidAttributeValueException {
		try {
			return new GenericDoubleValue(Double.parseDouble(val));
		} catch (NumberFormatException e) {
			throw new InvalidAttributeValueException(val, GenericDate.class.getSimpleName(), e.getMessage(), locale);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
		return fromString(val, locale);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		return Double.toString(((GenericDoubleValue) waarValue).getDouble());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		return new GenericDoubleValue(v);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		return new GenericDoubleValue(v);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof GenericDoubleValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}
