package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * GenericString is the Presentation layer string type
 * 
 * @author Erwin
 */
public class GenericString extends PresentationType {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) {
		return new GenericStringValue(val);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		String stringValue = ((GenericStringValue) waarValue).getString();
		StringBuffer stringBuffer = new StringBuffer(stringValue);
		int p;
		while ((p = stringBuffer.indexOf("\"")) >= 0) { //$NON-NLS-1$
			stringBuffer.deleteCharAt(p).insert(p, "&quot;"); //$NON-NLS-1$
		}
		// while ((p = sb.indexOf("'")) >= 0) { //$NON-NLS-1$
		// sb.deleteCharAt(p).insert(p,"&apost;"); //$NON-NLS-1$
		// }
		while ((p = stringBuffer.indexOf("<")) >= 0) { //$NON-NLS-1$
			stringBuffer.deleteCharAt(p).insert(p, "&lt;"); //$NON-NLS-1$
		}
		while ((p = stringBuffer.indexOf(">")) >= 0) { //$NON-NLS-1$
			stringBuffer.deleteCharAt(p).insert(p, "&gt;"); //$NON-NLS-1$
		}
		// while ((p = sb.indexOf("&")) >= 0) { //$NON-NLS-1$
		// sb.deleteCharAt(p).insert(p,"&amp;"); //$NON-NLS-1$
		// }
		return stringBuffer.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("TEXTAREA")) { //$NON-NLS-1$
			return TextAreaRenderer.getInstance();
		}
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		return new GenericStringValue(Integer.toString(v));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		return new GenericStringValue(Long.toString(v));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		return new GenericStringValue(I18N.getString(locale, "Logical.True")); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof GenericStringValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}
