package be.WAAR.PresentationLayer;

import java.text.*;
import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * GenericTime is the presentation type for time values. It encodes and decodes taking into account the user's preferred date and time formats.
 * 
 * @author Erwin
 */
public class GenericTime extends PresentationType {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
		if (val.length() == 0) {
			return null;
		} else {
			try {
				return new GenericTimeValue((userData == null ? ISOTimeFormat.getISOTimeFormatInstance() : userData.getPreferredTimeFormat()).parse(val));
			} catch (ParseException e1) {
				throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), e1.getMessage(), locale);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		if (waarValue instanceof GenericTimeValue) {
			UserData userData = userFunction.getUserData();
			SimpleDateFormat userDateFormat = userData == null ? ISOTimeFormat.getISOTimeFormatInstance() : userData.getPreferredTimeFormat();
			return userDateFormat.format(((GenericTimeValue) waarValue).getDateTime());
		} else {
			throw new IllegalArgumentException(waarValue.getClass().getName());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof GenericTimeValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}
