package be.WAAR.PresentationLayer;

import java.util.Date;

/**
 * @author Erwin
 */
public class GenericTimeStampValue implements WaarValue {

	/**
	 * The date value
	 */
	private Date dateTime;

	/**
	 * @param d
	 */
	public GenericTimeStampValue (Date d) {
		dateTime = d;
	}

	/**
	 * @param tm
	 */
	public GenericTimeStampValue (long tm) {
		dateTime = new Date(tm);
	}

	/**
	 * Gets The date value
	 * 
	 * @return The date value
	 */
	public Date getDateTime ( ) {
		return dateTime;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return dateTime.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.WaarValue#toWAARString(be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public String toWAARString (UserData userData) {
		return userData.getPreferredDateTimeFormat().format(dateTime);
	}
}
