/*
 * Created on 14-okt-2008
 */
package be.WAAR.PresentationLayer;

import java.util.HashMap;
import java.util.Map.Entry;

/**
 * Class holding a utility method to replace the <>'"& tokens with XML entity refs in XML output
 * 
 * @author Erwin Smout
 */
public class HTMLEntityRefs {

	/**
	 * 
	 */
	static final HTMLEntityRefs V2_0 = new HTMLEntityRefs(new Version((short) 2, (short) 0), null, getHTML20Map());

	/**
	 * 
	 */
	static final HTMLEntityRefs V3_2 = new HTMLEntityRefs(new Version((short) 3, (short) 2), V2_0, getHTML32Map());

	/**
	 * 
	 */
	static final HTMLEntityRefs V4_0 = new HTMLEntityRefs(new Version((short) 4, (short) 0), V3_2, getHTML40Map());

	/**
	 * 
	 */
	static final HTMLEntityRefs XHTMLV1_0 = new HTMLEntityRefs(new Version((short) 1, (short) 0), V4_0, getXHTML10Map());

	/**
	 * @return
	 */
	private static HashMap<String, String> getHTML20Map ( ) {
		HashMap<String, String> html20Map = new HashMap<String, String>();
		html20Map.put("\"", "&quot;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u0026", "&amp;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u003C", "&lt;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u003E", "&gt;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C0", "&Agrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C1", "&Aacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C2", "&Acirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C3", "&Atilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C4", "&Auml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C5", "&Aring;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C6", "&AElig;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C7", "&Ccedil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C8", "&Egrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00C9", "&Eacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CA", "&Ecirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CB", "&Euml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CC", "&Igrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CD", "&Iacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CE", "&Icirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00CF", "&Iuml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D0", "&ETH;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D1", "&Ntilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D2", "&Ograve;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D3", "&Oacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D4", "&Ocirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D5", "&Otilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D6", "&Ouml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D8", "&Oslash;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00D9", "&Ugrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DA", "&Uacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DB", "&Ucirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DC", "&Uuml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DD", "&Yacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DE", "&THORN;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00DF", "&szlig;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E0", "&agrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E1", "&aacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E2", "&acirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E3", "&atilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E4", "&auml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E5", "&aring;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E6", "&aelig;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E7", "&ccedil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E8", "&egrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00E9", "&eacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00EA", "&ecirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00EB", "&euml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00EC", "&igrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00ED", "&iacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00EE", "&icirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00EF", "&iuml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F0", "&eth;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F1", "&ntilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F2", "&ograve;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F3", "&oacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F4", "&ocirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F5", "&otilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F6", "&ouml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F8", "&oslash;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00F9", "&ugrave;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FA", "&uacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FB", "&ucirc;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FC", "&uuml;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FD", "&yacute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FE", "&thorn;"); //$NON-NLS-1$ //$NON-NLS-2$
		html20Map.put("\u00FF", "&yuml;"); //$NON-NLS-1$ //$NON-NLS-2$
		return html20Map;
	}

	/**
	 * @return
	 */
	private static HashMap<String, String> getHTML32Map ( ) {
		HashMap<String, String> html32Map = new HashMap<String, String>();
		html32Map.put("\u00D7", "&Otimes;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00F7", "&divide;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00A0", "&nbsp;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00A1", "&iexcl;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00A2", "&cent;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00A3", "&pound;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00A4", "&curren;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00A5", "&yen;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00A6", "&brvbar;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00A7", "&sect;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00A8", "&uml;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00A9", "&copy;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00AA", "&ordf;"); //$NON-NLS-1$//$NON-NLS-2$
		html32Map.put("\u00AB", "&laquo;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00AC", "&not;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00AD", "&shy;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00AE", "&reg;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00AF", "&macr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B0", "&deg;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B1", "&plusmn;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B2", "&sup2;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B3", "&sup3;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B4", "&acute;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B5", "&micro;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B6", "&para;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B7", "&middot;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B8", "&cedil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00B9", "&sup1;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BA", "&ordm;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BB", "&raquo;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BC", "&frac14;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BD", "&frac12;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BE", "&frac34;"); //$NON-NLS-1$ //$NON-NLS-2$
		html32Map.put("\u00BF", "&iquest;"); //$NON-NLS-1$ //$NON-NLS-2$

		return html32Map;
	}

	/**
	 * @return
	 */
	private static HashMap<String, String> getHTML40Map ( ) {
		HashMap<String, String> html40Map = new HashMap<String, String>();
		html40Map.put("\u0152", "&OElig;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0153", "&oelig;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0160", "&Scaron;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0161", "&scaron;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0178", "&Yuml;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0192", "&fnof;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u02C6", "&circ;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u02DC", "&tilde;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0391", "&Alpha;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0392", "&Beta;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0393", "&Gamma;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0394", "&Delta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0395", "&Epsilon;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0396", "&Zeta;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0397", "&Eta;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u0398", "&Theta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u0399", "&Iota;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039A", "&Kappa;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039B", "&Lambda;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039C", "&Mu;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039D", "&Nu;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039E", "&Xi;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u039F", "&Omicron;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A0", "&Pi;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A1", "&Rho;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A3", "&Sigma;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A4", "&Tau;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A5", "&Upsilon;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A6", "&Phi;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A7", "&Chi;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03A8", "&Psi;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03A9", "&Omega;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B1", "&alpha;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03B2", "&beta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B3", "&gamma;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B4", "&delta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B5", "&epsilon;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B6", "&zeta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B7", "&eta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B8", "&theta;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03B9", "&iota;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BA", "&kappa;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BB", "&lambda;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BC", "&mu;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BD", "&nu;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BE", "&xi;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03BF", "&omicron;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03C0", "&pi;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C1", "&rho;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C2", "&sigmaf;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C3", "&sigma;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C4", "&tau;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C5", "&upsilon;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C6", "&phi;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C7", "&chi;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C8", "&psi;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03C9", "&omega;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03D1", "&thetasym;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u03D2", "&upsih;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u03D6", "&piv;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2002", "&ensp;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2003", "&emsp;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2009", "&thinsp;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u200C", "&zwnj;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u200D", "&zwj;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u200E", "&lrm;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u200F", "&rlm;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2013", "&ndash;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2014", "&mdash;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2018", "&lsquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2019", "&rsquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u201A", "&sbquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u201C", "&ldquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u201D", "&rdquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u201E", "&bdquo;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2020", "&dagger;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2021", "&Dagger;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2022", "&bull;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2026", "&hellip;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2030", "&permil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2040", "&prime;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2033", "&Prime;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2039", "&lsaquo;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u203A", "&rsaquo;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u203E", "&oline;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2044", "&frasl;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u20AC", "&euro;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2111", "&image;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2118", "&weierp;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u211C", "&real;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2122", "&trade;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2135", "&alefsym;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2190", "&larr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2191", "&uarr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2192", "&rarr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2193", "&darr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2194", "&harr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21B5", "&crarr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21D0", "&lArr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21D1", "&uArr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21D2", "&rArr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21D3", "&dArr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u21D4", "&hArr;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2200", "&forall;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2202", "&part;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2203", "&exist;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2205", "&empty;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2207", "&nabla;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2208", "&isin;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2209", "&notin;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u220B", "&ni;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u220F", "&prod;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2211", "&sum;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2212", "&minus;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2217", "&lowast;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u221A", "&radic;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u221D", "&prop;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u221E", "&infin;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2220", "&ang;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2227", "&and;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2228", "&or;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2229", "&cap;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u222A", "&cup;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u222B", "&int;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2234", "&there4;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u223C", "&sim;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2245", "&cong;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2248", "&asymp;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2260", "&ne;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2261", "&equiv;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2264", "&le;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2265", "&ge;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2282", "&sub;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2283", "&sup;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2284", "&nsub;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2286", "&sube;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2287", "&supe;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2295", "&oplus;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2297", "&otimes;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u22A5", "&perp;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u22C5", "&sdot;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2308", "&lceil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2309", "&rceil;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u230A", "&lfloor;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u230B", "&rfloor;"); //$NON-NLS-1$ //$NON-NLS-2$
		html40Map.put("\u2329", "&lang;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u232A", "&rang;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u25CA", "&loz;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2660", "&spades;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2663", "&clubs;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2665", "&hearts;"); //$NON-NLS-1$//$NON-NLS-2$
		html40Map.put("\u2666", "&diams;"); //$NON-NLS-1$//$NON-NLS-2$

		return html40Map;
	}

	/**
	 * @return
	 */
	private static HashMap<String, String> getXHTML10Map ( ) {
		HashMap<String, String> xhtml10Map = new HashMap<String, String>();
		xhtml10Map.put("\u0027", "&apos;"); //$NON-NLS-1$ //$NON-NLS-2$

		return xhtml10Map;
	}

	/**
	 * Parses the given StringBuilder for appearances of known named html entity references, and replaces all such appearances with the appropriate character
	 * 
	 * @param entityRefToUniCodeChar
	 *            The map of known named entity refs to apply. This depends on the HTML version
	 * @param string
	 *            The string to parse for known html named entity references
	 * @return The same string object, with all appearances of known html named entity references replaced by the character those sequences stand for
	 */
	private static StringBuilder translateEntityRefs (HashMap<String, String> entityRefToUniCodeChar, String string) {
		StringBuilder stringBuilder = new StringBuilder(string);
		int p = 0;
		int sLength = stringBuilder.length();
		while (p < sLength) {
			if (stringBuilder.charAt(p) == '&') {
				int e = p + 1;
				StringBuilder entityRefName = new StringBuilder(16).append('&');
				while (e < sLength && stringBuilder.charAt(e) != ';') {
					entityRefName.append(stringBuilder.charAt(e++));
				}
				entityRefName.append(';');

				if (entityRefToUniCodeChar.containsKey(entityRefName.toString())) {
					// found an appearance of an entity ref - replace it.
					stringBuilder.replace(p, p + entityRefName.length(), entityRefToUniCodeChar.get(entityRefName.toString()));
					sLength = stringBuilder.length();
				}
			}
			p++;
		}

		return stringBuilder;
	}

	/**
	 * Parses the given StringBuilder for appearances of &#nnnn or &#xhhhh sequences, and replaces all such appearances with the appropriate character
	 * 
	 * @param stringBuilder
	 *            The string to parse for html numeric escape sequences
	 * @return The same string object, with all appearances of html escape sequences replaced by the character those sequences stand for
	 */
	private static String translateNumeralEntityRefs (StringBuilder stringBuilder) {
		int p = 0;
		int sLength = stringBuilder.length();
		while (p < sLength - 1) {
			if (stringBuilder.charAt(p) == '&' && stringBuilder.charAt(p + 1) == '#') {
				int e = p + 2;
				boolean hexmode;
				if (e < sLength && stringBuilder.charAt(e) == 'x') {
					hexmode = true;
					e++;
				} else {
					hexmode = false;
				}
				StringBuilder numeral = new StringBuilder(16);
				while (e < sLength && stringBuilder.charAt(e) != ';') {
					numeral.append(stringBuilder.charAt(e++));
				}
				e++; // make sure we include the ; when replacing
				int number;
				if (hexmode) {
					number = Integer.parseInt(numeral.toString(), 16);
				} else {
					number = Integer.parseInt(numeral.toString());
				}

				if (Character.isValidCodePoint(number)) {
					// found an appearance of an entity ref - replace it.
					stringBuilder.delete(p, e);
					stringBuilder.insert(p, Character.valueOf((char) number));
					sLength = stringBuilder.length();
				}
			}
			p++;
		}

		return stringBuilder.toString();
	}

//	/**
//	 * Runs a test
//	 * 
//	 * @param args
//	 *            the arguments to the main program
//	 */
//	public static void main (String[] args) {
//		System.out.println(V2_0.unicodeCharToEntityRef);
//		System.out.println(V2_0.fromEntityRefsToUnicodeString("&lt; &#x0152; &#338; &pound; &Pi;")); //$NON-NLS-1$
//		System.out.println(V3_2.unicodeCharToEntityRef);
//		System.out.println(V3_2.fromEntityRefsToUnicodeString("&lt; &#x0152; &#338; &pound; &Pi;")); //$NON-NLS-1$
//		System.out.println(V4_0.unicodeCharToEntityRef);
//		System.out.println(V4_0.fromEntityRefsToUnicodeString("&lt; &#x0152; &#338; &pound; &Pi;")); //$NON-NLS-1$
//		System.out.println(XHTMLV1_0.unicodeCharToEntityRef);
//		System.out.println(XHTMLV1_0.fromEntityRefsToUnicodeString("&lt; &#x0152; &#338; &pound; &Pi;")); //$NON-NLS-1$
//	}

	/**
	 * Gets the XML version of the input string, i.e. with all <>'"& characters replaced by their appropriate entity references
	 * 
	 * @param string
	 *            the string to be rendered to valid xml
	 * @return the XML version of the input string, i.e. with all <>'"& characters replaced by their appropriate entity references
	 */
	public static String toXML (String string) {
		int length = string.length();
		StringBuffer w = new StringBuffer(length + length >>> 3);
		int i = 0;
		while (i < length) {
			char c = string.charAt(i++);
			switch (c) {
				case '<':
					w.append("&lt;"); //$NON-NLS-1$
					break;
				case '>':
					w.append("&gt;"); //$NON-NLS-1$
					break;
				case '&':
					w.append("&amp;"); //$NON-NLS-1$
					break;
				case '"':
					w.append("&quot;"); //$NON-NLS-1$
					break;
				case '\'':
					w.append("&apos;"); //$NON-NLS-1$
					break;
				default:
					w.append(c);
					break;
			}
		}
		return w.toString();
	}

	/**
	 * The mappings of entity ref names to unicode points
	 */
	private HashMap<String, String> entityRefToUniCodeChar;

	/**
	 * The version of the set of HTML entity refs that preceded this one (i.e. the HTML version whose set of entity refs was extended by this set of entity refs)
	 */
	private HTMLEntityRefs overAndAboveVersion;

	/**
	 * The mappings of unicode points to entity ref names
	 */
	private HashMap<String, String> unicodeCharToEntityRef;

	/**
	 * The version of the set of HTML entity refs (i.e. the HTML version that introduced this set of entity refs)
	 */
	private Version version;

	/**
	 * prevent instantiation
	 * 
	 * @param overAndAboveVersion
	 * @param version
	 * @param unicodeCharToEntityRef
	 */
	private HTMLEntityRefs (Version version, HTMLEntityRefs overAndAboveVersion, HashMap<String, String> unicodeCharToEntityRef) {
		this.version = version;
		this.overAndAboveVersion = overAndAboveVersion;
		this.unicodeCharToEntityRef = unicodeCharToEntityRef;
		this.entityRefToUniCodeChar = new HashMap<String, String>();
		for (Entry<String, String> me : unicodeCharToEntityRef.entrySet()) {
			entityRefToUniCodeChar.put(me.getValue(), me.getKey());
		}
	}

	/**
	 * Processes the input string and replaces all appearances of entity references that are valid under the htmlVersion specified with their actual codepoint value.
	 * 
	 * @param string
	 *            The input string to be "sanitized" from &#nnnn and &#xhhhh appearances, as well as any named entity refs valid in the given html Version.
	 * @return The sanitized string
	 */
	public String fromEntityRefsToUnicodeString (String string) {
		if (overAndAboveVersion != null) {
			return translateEntityRefs(entityRefToUniCodeChar, overAndAboveVersion.fromEntityRefsToUnicodeString(string)).toString();
		} else {
			return translateEntityRefs(entityRefToUniCodeChar, translateNumeralEntityRefs(new StringBuilder(string))).toString();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return version.toString() + unicodeCharToEntityRef.toString();
	}
}
