package be.WAAR.PresentationLayer;

import java.io.*;
import java.util.*;
import java.util.Map.Entry;

/**
 * @author Erwin
 */
public class HTMLPresentationHandler {

	/**
	 * 
	 */
	private static final String BODYHTML = ".bodyhtml"; //$NON-NLS-1$

	/**
	 * 
	 */
	private static final String FORMHTML = ".formhtml"; //$NON-NLS-1$

	/**
	 * The html template string
	 */
	private String bodyOutputTemplate;

	/**
	 * Comment for <code>formOutputTemplate</code>
	 */
	private String formOutputTemplate;

	/**
	 * Comment for <code>userFunction</code>
	 */
	private OnLinePresentationFunction userFunction;

	/**
	 * Creates the html handler
	 * 
	 * @param userFunction
	 */
	HTMLPresentationHandler (OnLinePresentationFunction userFunction) {
		this.userFunction = userFunction;
		String presentationName = userFunction.getPresentation().getName();
		String bodyHTMLResourceName = presentationName + BODYHTML;
		String formHTMLResourceName = presentationName + FORMHTML;
		Class<? extends OnLinePresentationFunction> applicationClass = userFunction.getClass();

		try {
			BufferedReader in = Architecture.getResourceReader(bodyHTMLResourceName, applicationClass);
			StringBuilder templateText = new StringBuilder(8192);
			String w;
			try {
				while ((w = in.readLine()) != null) {
					templateText.append(w);
				}
				bodyOutputTemplate = templateText.toString();
			} catch (IOException e1) {
				bodyOutputTemplate = "Error while building page template : " + e1.getMessage(); //$NON-NLS-1$
			} finally {
				try {
					in.close();
				} catch (IOException e2) {
					e2.printStackTrace(System.err);
				}
			}
		} catch (ResourceNotFoundException e3) {
			bodyOutputTemplate = ""; //$NON-NLS-1$
		}

		try {
			BufferedReader in = Architecture.getResourceReader(formHTMLResourceName, applicationClass);
			StringBuilder templateText = new StringBuilder(8192);
			String w;
			try {
				while ((w = in.readLine()) != null) {
					templateText.append(w);
				}
				formOutputTemplate = templateText.toString();
			} catch (IOException e1) {
				formOutputTemplate = "Error while building form template : " + e1.getMessage(); //$NON-NLS-1$
			} finally {
				try {
					in.close();
				} catch (IOException e2) {
					e2.printStackTrace(System.err);
				}
			}
		} catch (ResourceNotFoundException e) {
			formOutputTemplate = ""; //$NON-NLS-1$
		}
	}

	/**
	 * Creates the html output stream from the Presentation (which is located on the PresentationFunctionContext)
	 * 
	 * @param locale
	 * 
	 * @return The output in html format
	 */
	String createOutputData (Locale locale) {
		Presentation presentation = userFunction.getPresentation();
		HashMap<String, PresentationField> presentationFields = presentation.getPresentationFields();
		HashMap<String, WaarValue> presentationValues = presentation.getPresentationValues();
		StringBuilder formOutput = new StringBuilder(formOutputTemplate);
		StringBuilder bodyOutput = new StringBuilder(bodyOutputTemplate);

		//replace all ::label:: references with the actual label for the specified locale, in both bodyoutput and formoutput
		Properties presentationLocaleLabels = presentation.getLabels(locale);
		for (String label : presentationLocaleLabels.stringPropertyNames()) {
			String labelRef = "::" + label + "::"; //$NON-NLS-1$//$NON-NLS-2$
			String labelValue = presentationLocaleLabels.getProperty(label);
			int labelRefLength = labelRef.length();
			int i;

			// Iterate over the template body replacing all occurrences of ::this label:: with its value
			while ((i = bodyOutput.indexOf(labelRef)) >= 0) {
				bodyOutput.replace(i, i + labelRefLength, labelValue);
			}

			// Iterate over the form body replacing all occurrences of ::this label:: with its value
			while ((i = formOutput.indexOf(labelRef)) >= 0) {
				formOutput.replace(i, i + labelRefLength, labelValue);
			}
		}
		
		//Now replace all the field refs
		Iterator<Entry<String, PresentationField>> i_presentationFields = presentationFields.entrySet().iterator();
		while (i_presentationFields.hasNext()) {
			Entry<String, PresentationField> me = i_presentationFields.next();
			String fieldName = me.getKey();
			PresentationField presentationField = me.getValue();
			WaarValue presentationFieldValue = presentationValues.get(fieldName);
			String presentationFieldHtmlValue;
			String presentationFieldRenderedHtmlValue;
			if (presentationFieldValue == null) {
				presentationFieldHtmlValue = presentationField.getType().getEmptyNakedStringRepresentation(presentationField, locale);
				presentationFieldRenderedHtmlValue = presentationField.getPresentationRenderer().getEmptyHTML(presentationField, locale);
			} else {
				presentationFieldHtmlValue = presentationField.getType().getNakedStringRepresentation(presentationFieldValue, userFunction, presentationField, locale);
				presentationFieldRenderedHtmlValue = presentationField.getPresentationRenderer().getHTML(presentationFieldValue, userFunction, presentationField, locale);
			}

			String htmlFieldRef = "[[" + fieldName + "]]"; //$NON-NLS-1$//$NON-NLS-2$
			int htmlFieldRefLength = htmlFieldRef.length();
			int i;

			// Iterate over the template body replacing all occurrences of [[this fieldname]] with its value
			while ((i = bodyOutput.indexOf(htmlFieldRef)) >= 0) {
				bodyOutput.replace(i, i + htmlFieldRefLength, presentationFieldHtmlValue);
			}

			// Iterate over the form body replacing all occurrences of [[this fieldname]] with its value
			while ((i = formOutput.indexOf(htmlFieldRef)) >= 0) {
				formOutput.replace(i, i + htmlFieldRefLength, presentationFieldHtmlValue);
			}

			htmlFieldRef = "{{" + fieldName + "}}"; //$NON-NLS-1$//$NON-NLS-2$
			htmlFieldRefLength = htmlFieldRef.length();

			// Iterate over the template body replacing all occurrences of [[this fieldname]] with its value
			while ((i = bodyOutput.indexOf(htmlFieldRef)) >= 0) {
				bodyOutput.replace(i, i + htmlFieldRefLength, presentationFieldRenderedHtmlValue);
			}

			// Iterate over the form body replacing all occurrences of [[this fieldname]] with its value
			while ((i = formOutput.indexOf(htmlFieldRef)) >= 0) {
				formOutput.replace(i, i + htmlFieldRefLength, presentationFieldRenderedHtmlValue);
			}
		}

		// All other [[fieldname]] must be architecture values or else they are unknown
		String fieldValue;
		int pb, pe;

		// First do the body output
		do {
			pb = bodyOutput.toString().indexOf("[["); //$NON-NLS-1$
			if (pb >= 0) {
				String fieldName = bodyOutput.substring(pb + 2);
				pe = fieldName.indexOf("]]"); //$NON-NLS-1$
				fieldName = fieldName.substring(0, pe);
				try {
					fieldValue = Architecture.getArchitectureFieldValue(fieldName, userFunction);
				} catch (NotAnArchitectureFieldException e) {
					fieldValue = "##" + fieldName + "##"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				bodyOutput.delete(pb, pb + pe + 4);
				bodyOutput.insert(pb, fieldValue);
			}
		} while (pb >= 0);

		// Then repeat the same for the form output
		do {
			pb = formOutput.toString().indexOf("[["); //$NON-NLS-1$
			if (pb >= 0) {
				String fieldName = formOutput.substring(pb + 2);
				pe = fieldName.indexOf("]]"); //$NON-NLS-1$
				fieldName = fieldName.substring(0, pe);
				try {
					fieldValue = Architecture.getArchitectureFieldValue(fieldName, userFunction);
				} catch (NotAnArchitectureFieldException e) {
					fieldValue = "##" + fieldName + "##"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				formOutput.delete(pb, pb + pe + 4);
				formOutput.insert(pb, fieldValue);
			}
		} while (pb >= 0);

		LinkedList<String> presentationActions = presentation.getPresentationActions();
		// build the output string for the action buttons
		Iterator<String> i_presentationActions = presentationActions.iterator();
		String actionsHtml = ""; //$NON-NLS-1$
		int tabIndex = 30021;
		while (i_presentationActions.hasNext()) {
			String actionHtml = i_presentationActions.next();
			actionsHtml += "<INPUT type=\"submit\" name=\"Action\" value=\"" + actionHtml + "\" tabindex=\"" + (tabIndex++) + "\">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}

		StringBuilder hout = new StringBuilder(Architecture.architectureHtml);

		int bc = hout.toString().indexOf("[[BODYHTML]]"); //$NON-NLS-1$
		if (bc >= 0) {
			hout.replace(bc, bc + 12, bodyOutput.toString());
		}
		int fc = hout.toString().indexOf("[[FORMHTML]]"); //$NON-NLS-1$
		if (fc >= 0) {
			hout.replace(fc, fc + 12, formOutput.toString());
		}
		int ac = hout.toString().indexOf("[[ACTIONSHTML]]"); //$NON-NLS-1$
		if (ac >= 0) {
			hout.replace(ac, ac + 15, actionsHtml);
		}

		do {
			pb = hout.toString().indexOf("[["); //$NON-NLS-1$
			if (pb >= 0) {
				String fieldName = hout.substring(pb + 2);
				pe = fieldName.indexOf("]]"); //$NON-NLS-1$
				fieldName = fieldName.substring(0, pe);
				try {
					fieldValue = Architecture.getArchitectureFieldValue(fieldName, userFunction);
				} catch (NotAnArchitectureFieldException e) {
					fieldValue = "##" + fieldName + "##"; //$NON-NLS-1$//$NON-NLS-2$
				}
				hout.delete(pb, pb + pe + 4);
				hout.insert(pb, fieldValue);
			}
		} while (pb >= 0);

		return hout.toString();
	}
}
