/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author Erwin
 * 
 */
abstract class I18N {

	/**
	 * 
	 */
	private static final HashMap<String, ResourceBundle> resourceBundleMap = new HashMap<String, ResourceBundle>();

	/**
	 * @param locale
	 * @param key
	 * @return
	 */
	static String getString (Locale locale, String key) {
		ResourceBundle resourceBundle;
		if (resourceBundleMap.containsKey(locale.getLanguage())) {
			resourceBundle = resourceBundleMap.get(locale.getLanguage());
		} else {
			resourceBundle = ResourceBundle.getBundle(I18N.class.getName(), new Locale(locale.getLanguage()));
			resourceBundleMap.put(locale.getLanguage(), resourceBundle);
		}

		try {
			return resourceBundle.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	/**
	 * Prevent instantiation
	 */
	private I18N ( ) {

	}
}
