package be.WAAR.PresentationLayer;

import java.util.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * The DateFormat for the ISO date format (which is the default)
 * 
 * @author Erwin
 */
public class ISODateFormat extends SimpleDateFormat {

	/**
	 * The instance
	 */
	private static ISODateFormat ISODateFormatInstance = new ISODateFormat();

	/**
	 * 
	 */
	private static final long serialVersionUID = 7939229832215825528L;

	/**
	 * Formats a date in ISO format, i.e. yyyy-mm-dd.
	 * 
	 * @param date
	 *            The date to be formatted
	 * @return the Date, formatted in ISO format
	 */
	public static String formatISO (Date date) {
		if (date == null) {
			return null;
		} else {
			return ISODateFormatInstance.format(date);
		}
	}

	/**
	 * Gets The ISO DateFormat instance
	 * 
	 * @return The ISO DateFormat instance
	 */
	public static ISODateFormat getISODateFormatInstance ( ) {
		return ISODateFormatInstance;
	}

	/**
	 * Gets a Date object with the value represented by string
	 * 
	 * @param date
	 *            The string representing a date to be parsed
	 * @return the input date value as a Date object
	 */
	public static Date parseISO (String date) {
		if (date == null || date.length() < 1) {
			return null;
		} else {
			try {
				return ISODateFormatInstance.parse(date);
			} catch (ParseException e) {
				return null;
			}
		}
	}

	/**
	 * 
	 */
	private ISODateFormat ( ) {
		super("yyyy'-'MM'-'dd"); //$NON-NLS-1$
	}
}
