package be.WAAR.PresentationLayer;

import java.util.Date;
import java.text.SimpleDateFormat;

/**
 * The DateFormat object for the ISO time format (which is the default format for time values)
 * 
 * @author Erwin
 */
public class ISOTimeFormat extends SimpleDateFormat {

	/**
	 * The instance
	 */
	private static ISOTimeFormat ISOTimeFormatInstance = new ISOTimeFormat();

	/**
	 * 
	 */
	private static final long serialVersionUID = -5664675154334761602L;

	/**
	 * Formats a date value in ISO time format
	 * 
	 * @param date
	 *            The Date object holding a time value to be formatted
	 * @return the input time in ISO format
	 */
	public static String formatISO (Date date) {
		if (date == null) {
			return null;
		} else {
			return ISOTimeFormatInstance.format(date);
		}
	}

	/**
	 * Gets the ISOTimeFormat instance
	 * 
	 * @return the ISOTimeFormat instance
	 */
	public static ISOTimeFormat getISOTimeFormatInstance ( ) {
		return ISOTimeFormatInstance;
	}

	/**
	 * 
	 */
	private ISOTimeFormat ( ) {
		super("HH':'mm':'ss"); //$NON-NLS-1$
	}
}
