package be.WAAR.PresentationLayer;

import java.util.Date;
import java.text.SimpleDateFormat;

/**
 * The DateFormat object for the ISO timestamp format (which is the default)
 * 
 * @author Erwin
 */
public class ISOTimeStampFormat extends SimpleDateFormat {

	/**
	 * The instance
	 */
	private static ISOTimeStampFormat ISOTimeStampFormatInstance = new ISOTimeStampFormat();

	/**
	 * 
	 */
	private static final long serialVersionUID = 3779589324318052425L;

	/**
	 * Formats the input date in ISO format
	 * 
	 * @param date
	 *            The Date object whose value is to be formatted
	 * @return the input date in ISO format
	 */
	public static String formatISO (Date date) {
		if (date == null) {
			return null;
		} else {
			return ISOTimeStampFormatInstance.format(date);
		}
	}

	/**
	 * Gets the ISOTimeStampFormat instance
	 * 
	 * @return The ISOTimeStampFormat instance
	 */
	public static ISOTimeStampFormat getISOTimeStampFormatInstance ( ) {
		return ISOTimeStampFormatInstance;
	}

	/**
	 * 
	 */
	private ISOTimeStampFormat ( ) {
		super("yyyy'-'MM'-'dd'-'HH'.'mm'.'ss'.'sss'000'"); //$NON-NLS-1$
	}
}
