/*
 * Created on 28-jun-2006
 */
package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin Smout
 */
public class InvalidAttributeValueException extends WaarException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9064979983186444771L;

	/**
	 * @param value
	 * @param detailErrorMessage
	 * @param locale
	 */
	InvalidAttributeValueException (String value, String detailErrorMessage, Locale locale) {
		this(value, "-", detailErrorMessage, locale); //$NON-NLS-1$
	}

	/**
	 * @param value
	 * @param typename
	 * @param detailErrorMessage
	 * @param locale
	 */
	public InvalidAttributeValueException (String value, String typename, String detailErrorMessage, Locale locale) {
		super(MyMessageFormat.format(I18N.getString(locale, "InvalidAttributeValueException.Text"), new String[] { value, typename, detailErrorMessage })); //$NON-NLS-1$
	}
}
