/**
 * 
 */
package be.WAAR.PresentationLayer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

/**
 * @author Erwin
 * 
 */
final class ListRenderer extends Renderer {

	/**
	 * 
	 */
	private static Renderer instance = new ListRenderer();

	/**
	 * @return
	 */
	static Renderer getInstance ( ) {
		return instance;
	}

	/**
	 * Creates the ListRenderer
	 * 
	 */
	private ListRenderer ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getEmptyHTML (PresentationField presentationField, Locale locale) {
		return ""; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.Renderer#renderHTML(be.erwinsmout.WAAR.WaarValue, be.erwinsmout.WAAR.PresentationLayer.OnLinePresentationFunction, be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	@Override
	String getHTML (WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		ListValue listValue = (ListValue) presentationFieldValue;
		StringBuilder htmlFieldValue = new StringBuilder(30 * presentationField.getColumnCount() * listValue.getRowList().size());
		Iterator<HashMap<String, WaarValue>> i_listValueRows = listValue.getRowList().iterator();
		HashMap<String, WaarValue> rowValueMap;
		int replaceBeginPos, replaceEndPos;

		String fldHtml = ""; //$NON-NLS-1$
		while (i_listValueRows.hasNext()) {
			// get the valuemap that holds the row
			rowValueMap = i_listValueRows.next();
			// reset the column iterator
			StringBuffer rowHtml = new StringBuffer(presentationField.getRowTemplateText().toString());
			do {
				replaceBeginPos = rowHtml.toString().indexOf("[["); //$NON-NLS-1$
				if (replaceBeginPos >= 0) {
					String rowFieldName = rowHtml.substring(replaceBeginPos + 2);
					replaceEndPos = rowFieldName.indexOf("]]"); //$NON-NLS-1$
					if (replaceEndPos >= 0) {
						rowFieldName = rowFieldName.substring(0, replaceEndPos);
						try {
							fldHtml = Architecture.getArchitectureFieldValue(rowFieldName, userFunction);
						} catch (NotAnArchitectureFieldException e) {
							PresentationField listPresentationFieldColumn;
							try {
								listPresentationFieldColumn = presentationField.getColumn(rowFieldName, locale);
								if (listPresentationFieldColumn != null) {
									PresentationType listPresentationFieldColumnType = listPresentationFieldColumn.getType();
									if (rowValueMap.keySet().contains(rowFieldName)) {
										WaarValue colValue = rowValueMap.get(rowFieldName);
										fldHtml = listPresentationFieldColumnType.getNakedStringRepresentation(colValue, userFunction, listPresentationFieldColumn, locale);
									} else {
										fldHtml = listPresentationFieldColumnType.getEmptyNakedStringRepresentation(listPresentationFieldColumn, locale);
									}
								} else {
									// not found in listfieldmap, maybe in 'outer' presentation map ...
									HashMap<String, WaarValue> presentationValues = userFunction.getPresentation().getPresentationValues();
									HashMap<String, PresentationField> presentationFields = userFunction.getPresentation().getPresentationFields();
									if (presentationFields.containsKey(rowFieldName)) {
										listPresentationFieldColumn = presentationFields.get(rowFieldName);
										PresentationType listPresentationFieldColumnType = listPresentationFieldColumn.getType();
										if (presentationValues.keySet().contains(rowFieldName)) {
											WaarValue colValue = presentationValues.get(rowFieldName);
											fldHtml = listPresentationFieldColumnType.getNakedStringRepresentation(colValue, userFunction, listPresentationFieldColumn, locale);
										} else {
											fldHtml = listPresentationFieldColumnType.getEmptyNakedStringRepresentation(listPresentationFieldColumn, locale);
										}
									} else {
										fldHtml = "##" + rowFieldName + "##"; //$NON-NLS-1$//$NON-NLS-2$
									}
								}
							} catch (NoColumnsInNonListFieldsException e1) {

							}
						}
						rowHtml.delete(replaceBeginPos, replaceBeginPos + replaceEndPos + 4);
						rowHtml.insert(replaceBeginPos, fldHtml);
					}
				}
			} while (replaceBeginPos >= 0);


			do {
				replaceBeginPos = rowHtml.toString().indexOf("{{"); //$NON-NLS-1$
				if (replaceBeginPos >= 0) {
					String rowFieldName = rowHtml.substring(replaceBeginPos + 2);
					replaceEndPos = rowFieldName.indexOf("}}"); //$NON-NLS-1$
					if (replaceEndPos >= 0) {
						rowFieldName = rowFieldName.substring(0, replaceEndPos);
						try {
							fldHtml = Architecture.getArchitectureFieldValue(rowFieldName, userFunction);
						} catch (NotAnArchitectureFieldException e) {
							PresentationField listPresentationFieldColumn;
							try {
								listPresentationFieldColumn = presentationField.getColumn(rowFieldName, locale);
								if (listPresentationFieldColumn != null) {
									if (rowValueMap.keySet().contains(rowFieldName)) {
										WaarValue colValue = rowValueMap.get(rowFieldName);
										fldHtml = listPresentationFieldColumn.getPresentationRenderer().getHTML(colValue, userFunction, listPresentationFieldColumn, locale);
									} else {
										fldHtml = listPresentationFieldColumn.getPresentationRenderer().getEmptyHTML(listPresentationFieldColumn, locale);
									}
								} else {
									// not found in listfieldmap, maybe in 'outer' presentation map ...
									HashMap<String, WaarValue> presentationValues = userFunction.getPresentation().getPresentationValues();
									HashMap<String, PresentationField> presentationFields = userFunction.getPresentation().getPresentationFields();
									if (presentationFields.containsKey(rowFieldName)) {
										listPresentationFieldColumn = presentationFields.get(rowFieldName);
										if (presentationValues.keySet().contains(rowFieldName)) {
											WaarValue colValue = presentationValues.get(rowFieldName);
											fldHtml = listPresentationFieldColumn.getPresentationRenderer().getHTML(colValue, userFunction, listPresentationFieldColumn, locale);
										} else {
											fldHtml = listPresentationFieldColumn.getPresentationRenderer().getEmptyHTML(listPresentationFieldColumn, locale);
										}
									} else {
										fldHtml = "##" + rowFieldName + "##"; //$NON-NLS-1$//$NON-NLS-2$
									}
								}
							} catch (NoColumnsInNonListFieldsException e1) {

							}
						}
						rowHtml.delete(replaceBeginPos, replaceBeginPos + replaceEndPos + 4);
						rowHtml.insert(replaceBeginPos, fldHtml);
					}
				}
			} while (replaceBeginPos >= 0);
			htmlFieldValue.append(rowHtml);
		}
		return htmlFieldValue.toString();
	}
}
