package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * Logical is the presentation layer attribute type for logical (boolean) (truth) values
 * 
 * @author Erwin
 */
public class Logical extends PresentationType {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(java.lang.String)
	 */
	public WaarValue encode (String stringValue, UserData userData, Locale locale) throws InvalidAttributeValueException {
		// In HTML, if an input checkbox was checked, then its name/value are present in the parameters map
		String localOnValue = I18N.getString(locale, "Logical.On"); //$NON-NLS-1$
		String localYValue = I18N.getString(locale, "Logical.Y"); //$NON-NLS-1$
		String localYesValue = I18N.getString(locale, "Logical.Yes"); //$NON-NLS-1$
		String localTrueValue = I18N.getString(locale, "Logical.True"); //$NON-NLS-1$
		String localOffValue = I18N.getString(locale, "Logical.Off"); //$NON-NLS-1$
		String localNValue = I18N.getString(locale, "Logical.N"); //$NON-NLS-1$
		String localNoValue = I18N.getString(locale, "Logical.No"); //$NON-NLS-1$
		String localFalseValue = I18N.getString(locale, "Logical.False"); //$NON-NLS-1$
		if (stringValue.equalsIgnoreCase(localYesValue) || stringValue.equalsIgnoreCase(localYValue) || stringValue.equalsIgnoreCase(localTrueValue) || stringValue.equalsIgnoreCase(localOnValue)) {
			return new LogicalValue(true);
		} else {
			if (stringValue.equalsIgnoreCase(localNoValue) || stringValue.equalsIgnoreCase(localNValue) || stringValue.equalsIgnoreCase(localFalseValue) || stringValue.equalsIgnoreCase(localOffValue)) {
				return new LogicalValue(false);
			} else {
				Locale architectureLocale = Architecture.getDefaultLocale();
				localOnValue = I18N.getString(architectureLocale, "Logical.On"); //$NON-NLS-1$
				localYValue = I18N.getString(architectureLocale, "Logical.Y"); //$NON-NLS-1$
				localYesValue = I18N.getString(architectureLocale, "Logical.Yes"); //$NON-NLS-1$
				localTrueValue = I18N.getString(architectureLocale, "Logical.True"); //$NON-NLS-1$
				localOffValue = I18N.getString(architectureLocale, "Logical.Off"); //$NON-NLS-1$
				localNValue = I18N.getString(architectureLocale, "Logical.N"); //$NON-NLS-1$
				localNoValue = I18N.getString(architectureLocale, "Logical.No"); //$NON-NLS-1$
				localFalseValue = I18N.getString(architectureLocale, "Logical.False"); //$NON-NLS-1$
				if (stringValue.equalsIgnoreCase(localYesValue) || stringValue.equalsIgnoreCase(localYValue) || stringValue.equalsIgnoreCase(localTrueValue) || stringValue.equalsIgnoreCase(localOnValue)) {
					return new LogicalValue(true);
				} else {
					if (stringValue.equalsIgnoreCase(localNoValue) || stringValue.equalsIgnoreCase(localNValue) || stringValue.equalsIgnoreCase(localFalseValue) || stringValue.equalsIgnoreCase(localOffValue)) {
						return new LogicalValue(false);
					} else {
						throw new InvalidAttributeValueException(stringValue, this.getClass().getSimpleName(), localTrueValue + '/' + localFalseValue + '/' + localYesValue + '/' + localNoValue + '/', locale);
					}
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return CheckBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#emptyHTML(be.erwinsmout.WAAR.PresentationLayer.PresentationField)
	 */
	public String getEmptyNakedStringRepresentation (PresentationField presentationField, Locale locale) {
		return ""; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.AttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		return Boolean.toString(((LogicalValue) waarValue).getValue());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		if (renderingStyleName.equals("TEXTBOX")) { //$NON-NLS-1$
			return TextBoxRenderer.getInstance();
		}
		return CheckBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		return new LogicalValue(b);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof LogicalValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}
