package be.WAAR.PresentationLayer;

/**
 * LogicalValue is the Presentation layer attribute type for logical (boolean) values
 * 
 * @author Erwin
 */
public class LogicalValue implements WaarValue {

	/**
	 * The boolean value
	 */
	private boolean value;

	/**
	 * Creates the LogicalValue
	 * 
	 * @param value
	 *            The boolean value
	 */
	public LogicalValue (boolean value) {
		this.value = value;
	}

	/**
	 * Gets The logical value
	 * 
	 * @return The logical value
	 */
	public boolean getValue ( ) {
		return value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return Boolean.toString(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.WaarValue#toWAARString(be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public String toWAARString (UserData userData) {
		return Boolean.toString(value);
	}
}
