package be.WAAR.PresentationLayer;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * The LogonServlet handles the User logon procedure. The URL to which to return after the logon has completed, is present as the value of the return= parameter in the HttpServletRequest
 * 
 * @version 1.0
 * @author Erwin
 */
public class LogonServlet extends HttpServlet implements Servlet {

	/**
	 * 
	 */
	// private static ConsumerManager openIDConsumerManager;
	/**
	 * 
	 */
	private static final long serialVersionUID = 4763962818840118976L;

	/**
	 * static init
	 * 
	 */
	// static {
	// try {
	// openIDConsumerManager = new ConsumerManager();
	// } catch (Exception e) {
	// openIDConsumerManager = null;
	// }
	// }
	/**
	 * Processes the logon request. The HttpServletRequest has USERSESSIONID and return parameters
	 * 
	 * @param req
	 *            The request
	 * @param resp
	 *            The response object
	 * @throws ServletException
	 */
	private void process (HttpServletRequest req, HttpServletResponse resp) throws ServletException {
		UserSession userSession = Architecture.getUserSession(Long.parseLong(req.getParameter("USERSESSIONID"))); //$NON-NLS-1$
		PresentationFunctionStack functionStack = userSession.getFunctionStack();
		OnLinePresentationFunction userFunction;

		String action = req.getParameter("Action"); //$NON-NLS-1$
		if (action == null) {
			// This means that the logon function has to be initiated
			userFunction = new IdentifyUser();
//			userFunction.initialize(Architecture.WAAR, "", null, req.getParameter("return"), "", "IdentifyUser", req, this); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			userFunction.initialize(req.getContextPath().substring(1), "", null, req.getParameter("return"), "", "IdentifyUser", req, this); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			userFunction.setPresentationMessage(I18N.getString(Architecture.getDefaultLocale(), "LogonServlet.Text")); //$NON-NLS-1$
			functionStack.addLast(userFunction);

			// If openID libraries not available, disable the openID input field
			// if (openIDConsumerManager == null) {
			// try {
			//					userFunction.getPresentation().setPresentationFieldInOutMode("OPENIDUSERID", InOutMode.OUT, Architecture.getDefaultLocale()); //$NON-NLS-1$
			//					userFunction.setPresentationValue("OPENIDUSERID", I18N.getString(Architecture.getDefaultLocale(), "LogonServlet.OpenIDNotSupported")); //$NON-NLS-1$ //$NON-NLS-2$
			// } catch (WaarException e) {
			// req.getSession().invalidate();
			// Architecture.dropUserSession(userSession.getSessionID());
			// throw new ServletException(e);
			// }
			// }
			try {
				resp.getWriter().write(userFunction.getHTMLOutput());
			} catch (IOException e1) {
				throw new ServletException(e1.getMessage());
			}
		} else {
			// This means that OK, or cancel, or ... has been pressed on the logon function presentation
			userFunction = (OnLinePresentationFunction) functionStack.getLast();
			try {
				if (action.equalsIgnoreCase("OK")) { //$NON-NLS-1$
					userFunction.fillInPresentationValuesIgnoringDefaults(req);
					userFunction.doPresentationLogic();
					userFunction.endPresentationLogic();
					HashMap<String, WaarValue> presentationValues = userFunction.getPresentation().getPresentationValues();
					WaarValue userDateFormat_v = presentationValues.get("DATEFORMAT"); //$NON-NLS-1$
					String userDateFormat;
					if (userDateFormat_v == null) {
						userDateFormat = "yyyy'-'MM'-'dd"; //$NON-NLS-1$
					} else {
						userDateFormat = ((GenericStringValue) userDateFormat_v).getString();
					}
					WaarValue userTimeFormat_v = presentationValues.get("TIMEFORMAT"); //$NON-NLS-1$
					String userTimeFormat;
					if (userTimeFormat_v == null) {
						userTimeFormat = "HH':'mm':'ss"; //$NON-NLS-1$
					} else {
						userTimeFormat = ((GenericStringValue) userTimeFormat_v).getString();
					}

					String userID = ""; //$NON-NLS-1$
					//					GenericStringValue openIDUserIDValue = (GenericStringValue) presentationValues.get("OPENIDUSERID"); //$NON-NLS-1$
					// if (openIDConsumerManager != null && openIDUserIDValue != null) {
					//						if ("1".equals(req.getParameter("openIDReturn"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//
					// // extract the parameters from the authentication response (which comes in as a HTTP request from the OpenID provider)
					// ParameterList response = new ParameterList(req.getParameterMap());
					//
					// // extract the receiving URL from the HTTP request
					// StringBuffer receivingURL = req.getRequestURL();
					// String queryString = req.getQueryString();
					// if (queryString != null && queryString.length() > 0) {
					//								receivingURL.append("?").append(req.getQueryString()); //$NON-NLS-1$
					// }
					//
					// // examine the verification result and extract the verified identifier
					// Identifier verified;
					// try {
					// // retrieve the previously stored discovery information
					//								DiscoveryInformation discovered = (DiscoveryInformation) userFunction.getFromFunctionContextMandatory("openid-disc"); //$NON-NLS-1$
					//
					// // verify the response; ConsumerManager needs to be the same (static) instance used to place the authentication request
					// VerificationResult verification = openIDConsumerManager.verify(receivingURL.toString(), response, discovered);
					//
					// verified = verification.getVerifiedId();
					// if (verified == null) {
					// throw new OpenIDAuthenticationFailedException();
					// }
					//
					// AuthSuccess authSuccess = (AuthSuccess) verification.getAuthResponse();
					//
					// if (authSuccess.hasExtension(SRegMessage.OPENID_NS_SREG)) {
					// MessageExtension ext = authSuccess.getExtension(SRegMessage.OPENID_NS_SREG);
					// if (ext instanceof SRegResponse) {
					// SRegResponse sregResp = (SRegResponse) ext;
					// for (Iterator iter = sregResp.getAttributeNames().iterator(); iter.hasNext();) {
					// String name = (String) iter.next();
					// String value = sregResp.getParameterValue(name);
					// req.setAttribute(name, value);
					// }
					// }
					// }
					// if (authSuccess.hasExtension(AxMessage.OPENID_NS_AX)) {
					// FetchResponse fetchResp = (FetchResponse) authSuccess.getExtension(AxMessage.OPENID_NS_AX);
					//
					// // List emails = fetchResp.getAttributeValues("email");
					// // String email = (String) emails.get(0);
					//
					// List aliases = fetchResp.getAttributeAliases();
					// for (Iterator iter = aliases.iterator(); iter.hasNext();) {
					// String alias = (String) iter.next();
					// List values = fetchResp.getAttributeValues(alias);
					// if (values.size() > 0) {
					// req.setAttribute(alias, values.get(0));
					// }
					// }
					// }
					// } catch (MessageException e) {
					// throw new ServletException(e);
					// } catch (DiscoveryException e) {
					// throw new ServletException(e);
					// } catch (AssociationException e) {
					// throw new ServletException(e);
					// }
					//
					// userID = verified.getIdentifier();
					// // req.setAttribute("identifier", verified.getIdentifier());
					// // this.getServletContext().getRequestDispatcher("/return.jsp").forward(req, resp);
					// } else {
					//
					// try {
					// // determine a return_to URL where your application will receive the authentication responses from the OpenID provider
					//								String returnToUrl = req.getRequestURI().toString() + "?openIDReturn=1"; //$NON-NLS-1$
					//
					// // perform discovery on the user-supplied identifier
					// List discoveries = openIDConsumerManager.discover(openIDUserIDValue.getString());
					//
					// // attempt to associate with the OpenID provider
					// // and retrieve one service endpoint for authentication
					// DiscoveryInformation discovered = openIDConsumerManager.associate(discoveries);
					//
					// // store the discovery information in the user's session
					//								userFunction.saveInFunctionContext("openid-disc", discovered); //$NON-NLS-1$
					//
					// // obtain a AuthRequest message to be sent to the OpenID provider
					// AuthRequest authReq = openIDConsumerManager.authenticate(discovered, returnToUrl);
					//
					// // Attribute Exchange example: fetching the 'email' attribute
					// FetchRequest fetch = FetchRequest.createFetchRequest();
					// SRegRequest sregReq = SRegRequest.createFetchRequest();
					//
					//								if ("1".equals(req.getParameter("nickname"))) { //$NON-NLS-1$ //$NON-NLS-2$
					// // fetch.addAttribute("nickname",
					// // "http://schema.openid.net/contact/nickname", false);
					//									sregReq.addAttribute("nickname", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("email"))) { //$NON-NLS-1$//$NON-NLS-2$
					//									fetch.addAttribute("email", "http://schema.openid.net/contact/email", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("email", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("fullname"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//									fetch.addAttribute("fullname", "http://schema.openid.net/contact/fullname", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("fullname", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("dob"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//									fetch.addAttribute("dob", "http://schema.openid.net/contact/dob", true); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("dob", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("gender"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//									fetch.addAttribute("gender", "http://schema.openid.net/contact/gender", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("gender", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("postcode"))) { //$NON-NLS-1$//$NON-NLS-2$
					//									fetch.addAttribute("postcode", "http://schema.openid.net/contact/postcode", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("postcode", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("country"))) { //$NON-NLS-1$//$NON-NLS-2$
					//									fetch.addAttribute("country", "http://schema.openid.net/contact/country", false); //$NON-NLS-1$//$NON-NLS-2$
					//									sregReq.addAttribute("country", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("language"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//									fetch.addAttribute("language", "http://schema.openid.net/contact/language", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("language", false); //$NON-NLS-1$
					// }
					//								if ("1".equals(req.getParameter("timezone"))) { //$NON-NLS-1$ //$NON-NLS-2$
					//									fetch.addAttribute("timezone", "http://schema.openid.net/contact/timezone", false); //$NON-NLS-1$ //$NON-NLS-2$
					//									sregReq.addAttribute("timezone", false); //$NON-NLS-1$
					// }
					//
					// // attach the extension to the authentication request
					// if (!sregReq.getAttributes().isEmpty()) {
					// authReq.addExtension(sregReq);
					// }
					//
					// // if (!discovered.isVersion2()) {
					// // Option 1: GET HTTP-redirect to the OpenID Provider endpoint
					// // The only method supported in OpenID 1.x
					// // redirect-URL usually limited ~2048 bytes
					// resp.sendRedirect(authReq.getDestinationUrl(true));
					// // return null;
					// // } else {
					// // // Option 2: HTML FORM Redirection (Allows payloads >2048 bytes)
					// //
					// // RequestDispatcher dispatcher = getServletContext()
					// // .getRequestDispatcher("/formredirection.jsp");
					// // req.setAttribute("prameterMap", req.getParameterMap());
					// // req.setAttribute("message", authReq);
					// // // req.setAttribute("destinationUrl", resp
					// // // .getDestinationUrl(false));
					// // dispatcher.forward(req, resp);
					// // }
					// } catch (DiscoveryException e) {
					// throw new ServletException(e);
					// } catch (MessageException e) {
					// throw new ServletException(e);
					// } catch (ConsumerException e) {
					// throw new ServletException(e);
					// } catch (IOException e) {
					// throw new ServletException(e);
					// }
					//
					// }
					// } else {
					// // logon using server-local userIDs
					//						UserIDValue userIDValue = ((UserIDValue) presentationValues.get("USERID")); //$NON-NLS-1$
					//						userID = userIDValue != null ? userIDValue.getUserID().toLowerCase() : ""; //$NON-NLS-1$
					// if (userID.length() > 0) {
					//							GenericStringValue userPasswordValue = ((GenericStringValue) presentationValues.get("PASSWORD")); //$NON-NLS-1$
					//							String userPassword = userPasswordValue != null ? userPasswordValue.getString() : ""; //$NON-NLS-1$
					//							GenericStringValue newPasswordValue = ((GenericStringValue) presentationValues.get("NEWPASSWORD")); //$NON-NLS-1$
					//							String newPassword = newPasswordValue != null ? newPasswordValue.getString() : ""; //$NON-NLS-1$
					//							GenericStringValue confirmNewPasswordValue = ((GenericStringValue) presentationValues.get("CONFIRMNEWPASSWORD")); //$NON-NLS-1$
					//							String confirmNewPassword = confirmNewPasswordValue != null ? confirmNewPasswordValue.getString() : ""; //$NON-NLS-1$
					//
					// Architecture.checkPassword(userID, userPassword, newPassword, confirmNewPassword);
					// }
					// }

					UserData userData = new UserData(userID, userDateFormat, userTimeFormat, ((GenericStringValue) presentationValues.get("LANGUAGE")), userSession); //$NON-NLS-1$
					userSession.setUserData(userData);

					String backto = userFunction.getReturnPath();
					String backparms = userFunction.getQueryString();
					if (backparms == null) {
						backparms = "USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken(); //$NON-NLS-1$ //$NON-NLS-2$
					} else {
						backparms = backparms + "&USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken(); //$NON-NLS-1$ //$NON-NLS-2$
					}
					functionStack.removeLast();
					String erdurl = resp.encodeRedirectURL(backto + "?" + backparms); //$NON-NLS-1$
					try {
						resp.sendRedirect(erdurl);
					} catch (IOException e2) {
						throw new ServletException(e2.getMessage());
					}
				} else {
					if (action.equalsIgnoreCase("CANCEL")) { //$NON-NLS-1$
						// go back to menu screen
						Architecture.dropUserSession(userSession.getSessionID());
						String erdurl = resp.encodeRedirectURL(req.getContextPath());
						try {
							resp.sendRedirect(erdurl);
						} catch (IOException e) {
							log(e.getMessage(), e);
							req.getSession().invalidate();
							Architecture.dropUserSession(userSession.getSessionID());
							throw new ServletException(e.getMessage());
						}
					} else {
						userFunction.fillInPresentationValuesIgnoringDefaults(req);
						userFunction.doActionLogic(action);
						try {
							resp.getWriter().write(userFunction.getHTMLOutput());
						} catch (IOException e1) {
							throw new ServletException(e1.getMessage());
						}
					}
				}
			} catch (WaarException e3) {
				userFunction.setPresentationMessage(e3);
				try {
					resp.getWriter().write(userFunction.getHTMLOutput());
				} catch (IOException e1) {
					throw new ServletException(e1.getMessage());
				}
			}
		}
	}

	/**
	 * @see javax.servlet.http.HttpServlet#doGet (javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void doGet (HttpServletRequest req, HttpServletResponse resp) throws ServletException {
		process(req, resp);
	}

	/**
	 * @see javax.servlet.http.HttpServlet#doPost (javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void doPost (HttpServletRequest req, HttpServletResponse resp) throws ServletException {
		process(req, resp);
	}
}
