package be.WAAR.PresentationLayer;

import java.util.Locale;

import be.erwinsmout.MyMessageFormat;

/**
 * @author Erwin
 */
public class Name extends PresentationType {

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.waar.AttributeType#validate(be.erwinsmout.waar.Value)
	 */
	public WaarValue encode (String val, UserData userData, Locale locale) {
		return new NameValue(val);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getDefaultPresentationRenderingStyle()
	 */
	@Override
	public Renderer getDefaultPresentationRenderingStyle ( ) {
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationAttributeType#decode(be.erwinsmout.WAAR.WaarValue)
	 */
	public String getNakedStringRepresentation (WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
		return ((NameValue) waarValue).getName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.WAAR.PresentationLayer.PresentationType#getPresentationRenderingStyle(java.lang.String)
	 */
	@Override
	public Renderer getPresentationRenderingStyle (String renderingStyleName) {
		if (renderingStyleName.equalsIgnoreCase("PASSWORD")) { //$NON-NLS-1$
			return PassWordRenderer.getInstance();
		}
		return TextBoxRenderer.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(int)
	 */
	@Override
	public WaarValue getWaarValue (int v, Locale locale) {
		return new NameValue(Integer.toString(v));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(long, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (long v, Locale locale) {
		return new NameValue(Long.toString(v));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#getWaarValue(boolean, java.util.Locale)
	 */
	@Override
	public WaarValue getWaarValue (boolean b, Locale locale) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.WAAR.PresentationLayer.PresentationType#checkValidWaarValue(be.WAAR.PresentationLayer.WaarValue, be.WAAR.PresentationLayer.UserData)
	 */
	@Override
	public WaarValue checkValidWaarValue (WaarValue value, UserData userData) throws InvalidAttributeValueException {
		if (!(value instanceof NameValue)) {
			Locale locale = userData.getLocale();
			throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[] { getClass().getName(), value.getClass().getName() }), locale); //$NON-NLS-1$
		}
		return value;
	}
}
